/*
 * Decompiled with CFR 0.152.
 */
package com.github.choonchernlim.security.adfs.saml2;

import com.github.choonchernlim.betterPreconditions.preconditions.PreconditionFactory;
import com.github.choonchernlim.security.adfs.saml2.KeystoreBean;
import com.github.choonchernlim.security.adfs.saml2.KeystoreBeanBuilder;
import com.github.choonchernlim.security.adfs.saml2.SpringSecurityAdfsSaml2Exception;
import com.google.common.base.Splitter;
import java.io.InputStream;
import java.security.KeyStore;
import java.util.Iterator;
import java.util.List;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.jndi.JndiTemplate;

public class JndiBackedKeystoreService {
    private final ResourceLoader resourceLoader = new DefaultResourceLoader();
    private final String jndiName;
    private JndiTemplate jndiTemplate = new JndiTemplate();

    public JndiBackedKeystoreService(String jndiName) {
        this.jndiName = jndiName;
    }

    public void setJndiTemplate(JndiTemplate jndiTemplate) {
        this.jndiTemplate = jndiTemplate;
    }

    public KeystoreBean get() {
        Iterator<String> ite = this.getJndiValues();
        return this.getKeystoreBean(ite.next(), ite.next(), ite.next(), ite.next());
    }

    private Iterator<String> getJndiValues() {
        String jndiValue;
        try {
            jndiValue = (String)this.jndiTemplate.lookup(this.jndiName, String.class);
        }
        catch (Exception e) {
            throw new SpringSecurityAdfsSaml2Exception(String.format("Unable to get value from JNDI: %s", this.jndiName), e);
        }
        List jndiValues = Splitter.on((String)",").trimResults().splitToList((CharSequence)jndiValue);
        PreconditionFactory.expect((Number)jndiValues.size(), (String)"jndiValues size").toBeEqual((Number)4).check();
        return jndiValues.iterator();
    }

    private KeystoreBean getKeystoreBean(String jksPath, String keystoreAlias, String keystorePassword, String keystorePrivateKeyPassword) {
        KeyStore keyStore;
        InputStream keystoreInputStream;
        Resource keystoreResource = this.resourceLoader.getResource(jksPath);
        try {
            keystoreInputStream = keystoreResource.getInputStream();
        }
        catch (Exception e) {
            throw new SpringSecurityAdfsSaml2Exception("Invalid keystore path", e);
        }
        try {
            keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        }
        catch (Exception e) {
            throw new SpringSecurityAdfsSaml2Exception("Unable to initialize keystore", e);
        }
        try {
            keyStore.load(keystoreInputStream, keystorePassword.toCharArray());
        }
        catch (Exception e) {
            throw new SpringSecurityAdfsSaml2Exception("Invalid keystore password", e);
        }
        try {
            if (!keyStore.isKeyEntry(keystoreAlias)) {
                throw new IllegalArgumentException("Provided alias not found");
            }
        }
        catch (Exception e) {
            throw new SpringSecurityAdfsSaml2Exception("Invalid keystore alias", e);
        }
        try {
            keyStore.getKey(keystoreAlias, keystorePrivateKeyPassword.toCharArray());
        }
        catch (Exception e) {
            throw new SpringSecurityAdfsSaml2Exception("Invalid keystore private key password", e);
        }
        return new KeystoreBeanBuilder().withJksPath(jksPath).withKeystoreAlias(keystoreAlias).withKeystorePassword(keystorePassword).withKeystorePrivateKeyPassword(keystorePrivateKeyPassword).withKeystoreResource(keystoreResource).build();
    }
}

