/*
 * Decompiled with CFR 0.152.
 */
package com.github.choonchernlim.security.adfs.saml2;

import com.github.choonchernlim.security.adfs.saml2.DefaultSAMLBootstrap;
import com.github.choonchernlim.security.adfs.saml2.SAMLConfigBean;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import javax.servlet.Filter;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.velocity.app.VelocityEngine;
import org.opensaml.saml2.metadata.provider.HTTPMetadataProvider;
import org.opensaml.saml2.metadata.provider.MetadataProvider;
import org.opensaml.saml2.metadata.provider.MetadataProviderException;
import org.opensaml.xml.parse.ParserPool;
import org.opensaml.xml.parse.StaticBasicParserPool;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.MethodInvokingFactoryBean;
import org.springframework.context.annotation.Bean;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.saml.SAMLAuthenticationProvider;
import org.springframework.security.saml.SAMLBootstrap;
import org.springframework.security.saml.SAMLDiscovery;
import org.springframework.security.saml.SAMLEntryPoint;
import org.springframework.security.saml.SAMLLogoutFilter;
import org.springframework.security.saml.SAMLLogoutProcessingFilter;
import org.springframework.security.saml.SAMLProcessingFilter;
import org.springframework.security.saml.SAMLWebSSOHoKProcessingFilter;
import org.springframework.security.saml.context.SAMLContextProviderImpl;
import org.springframework.security.saml.key.JKSKeyManager;
import org.springframework.security.saml.key.KeyManager;
import org.springframework.security.saml.log.SAMLDefaultLogger;
import org.springframework.security.saml.metadata.CachingMetadataManager;
import org.springframework.security.saml.metadata.ExtendedMetadataDelegate;
import org.springframework.security.saml.metadata.MetadataDisplayFilter;
import org.springframework.security.saml.metadata.MetadataGenerator;
import org.springframework.security.saml.metadata.MetadataGeneratorFilter;
import org.springframework.security.saml.parser.ParserPoolHolder;
import org.springframework.security.saml.processor.HTTPArtifactBinding;
import org.springframework.security.saml.processor.HTTPPAOS11Binding;
import org.springframework.security.saml.processor.HTTPPostBinding;
import org.springframework.security.saml.processor.HTTPRedirectDeflateBinding;
import org.springframework.security.saml.processor.HTTPSOAP11Binding;
import org.springframework.security.saml.processor.SAMLBinding;
import org.springframework.security.saml.processor.SAMLProcessor;
import org.springframework.security.saml.processor.SAMLProcessorImpl;
import org.springframework.security.saml.trust.httpclient.TLSProtocolConfigurer;
import org.springframework.security.saml.trust.httpclient.TLSProtocolSocketFactory;
import org.springframework.security.saml.util.VelocityFactory;
import org.springframework.security.saml.websso.ArtifactResolutionProfile;
import org.springframework.security.saml.websso.ArtifactResolutionProfileImpl;
import org.springframework.security.saml.websso.SingleLogoutProfile;
import org.springframework.security.saml.websso.SingleLogoutProfileImpl;
import org.springframework.security.saml.websso.WebSSOProfile;
import org.springframework.security.saml.websso.WebSSOProfileConsumer;
import org.springframework.security.saml.websso.WebSSOProfileConsumerHoKImpl;
import org.springframework.security.saml.websso.WebSSOProfileConsumerImpl;
import org.springframework.security.saml.websso.WebSSOProfileECPImpl;
import org.springframework.security.saml.websso.WebSSOProfileImpl;
import org.springframework.security.saml.websso.WebSSOProfileOptions;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.DefaultSecurityFilterChain;
import org.springframework.security.web.FilterChainProxy;
import org.springframework.security.web.access.channel.ChannelProcessingFilter;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.SavedRequestAwareAuthenticationSuccessHandler;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationFailureHandler;
import org.springframework.security.web.authentication.logout.LogoutHandler;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;
import org.springframework.security.web.authentication.logout.SecurityContextLogoutHandler;
import org.springframework.security.web.authentication.logout.SimpleUrlLogoutSuccessHandler;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

public abstract class SAMLWebSecurityConfigurerAdapter
extends WebSecurityConfigurerAdapter {
    @Autowired
    private SAMLAuthenticationProvider samlAuthenticationProvider;

    @Bean
    public static SAMLBootstrap samlBootstrap() {
        return new DefaultSAMLBootstrap();
    }

    @Bean
    protected abstract SAMLConfigBean samlConfigBean();

    protected final HttpSecurity samlizedConfig(HttpSecurity http) throws Exception {
        ((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((HttpSecurity)http.httpBasic().authenticationEntryPoint((AuthenticationEntryPoint)this.samlEntryPoint()).and()).csrf().ignoringAntMatchers(new String[]{"/saml/**"}).and()).authorizeRequests().antMatchers(new String[]{"/saml/**"})).permitAll().and()).addFilterBefore((Filter)this.metadataGeneratorFilter(), ChannelProcessingFilter.class).addFilterAfter((Filter)this.filterChainProxy(), BasicAuthenticationFilter.class);
        return http;
    }

    protected final WebSecurity samlizedConfig(WebSecurity web) throws Exception {
        web.ignoring().antMatchers(new String[]{this.samlConfigBean().getSuccessLogoutUrl()});
        return web;
    }

    private String getMetdataUrl() {
        return String.format("https://%s/federationmetadata/2007-06/federationmetadata.xml", this.samlConfigBean().getAdfsHostName());
    }

    @Bean
    public SAMLEntryPoint samlEntryPoint() {
        WebSSOProfileOptions webSSOProfileOptions = new WebSSOProfileOptions();
        webSSOProfileOptions.setIncludeScoping(Boolean.valueOf(false));
        webSSOProfileOptions.setBinding("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect");
        webSSOProfileOptions.setForceAuthN(Boolean.valueOf(true));
        if (!this.samlConfigBean().getAuthnContexts().isEmpty()) {
            webSSOProfileOptions.setAuthnContexts(this.samlConfigBean().getAuthnContexts());
        }
        SAMLEntryPoint samlEntryPoint = new SAMLEntryPoint();
        samlEntryPoint.setDefaultProfileOptions(webSSOProfileOptions);
        return samlEntryPoint;
    }

    @Bean
    public MetadataGeneratorFilter metadataGeneratorFilter() {
        MetadataGenerator metadataGenerator = new MetadataGenerator();
        metadataGenerator.setKeyManager(this.keyManager());
        metadataGenerator.setEntityBaseURL(this.samlConfigBean().getSpMetadataBaseUrl());
        return new MetadataGeneratorFilter(metadataGenerator);
    }

    @Bean
    public HttpClient httpClient() {
        return new HttpClient((HttpConnectionManager)new MultiThreadedHttpConnectionManager());
    }

    @Bean
    public FilterChainProxy filterChainProxy() throws Exception {
        return new FilterChainProxy((List)ImmutableList.of((Object)new DefaultSecurityFilterChain((RequestMatcher)new AntPathRequestMatcher("/saml/login/**"), new Filter[]{this.samlEntryPoint()}), (Object)new DefaultSecurityFilterChain((RequestMatcher)new AntPathRequestMatcher("/saml/logout/**"), new Filter[]{this.samlLogoutFilter()}), (Object)new DefaultSecurityFilterChain((RequestMatcher)new AntPathRequestMatcher("/saml/metadata/**"), new Filter[]{this.metadataDisplayFilter()}), (Object)new DefaultSecurityFilterChain((RequestMatcher)new AntPathRequestMatcher("/saml/SSO/**"), new Filter[]{this.samlProcessingFilter()}), (Object)new DefaultSecurityFilterChain((RequestMatcher)new AntPathRequestMatcher("/saml/SSOHoK/**"), new Filter[]{this.samlWebSSOHoKProcessingFilter()}), (Object)new DefaultSecurityFilterChain((RequestMatcher)new AntPathRequestMatcher("/saml/SingleLogout/**"), new Filter[]{this.samlLogoutProcessingFilter()}), (Object)new DefaultSecurityFilterChain((RequestMatcher)new AntPathRequestMatcher("/saml/discovery/**"), new Filter[]{this.samlIDPDiscovery()})));
    }

    @Bean
    public SavedRequestAwareAuthenticationSuccessHandler successRedirectHandler() {
        SavedRequestAwareAuthenticationSuccessHandler successRedirectHandler = new SavedRequestAwareAuthenticationSuccessHandler();
        successRedirectHandler.setDefaultTargetUrl(this.samlConfigBean().getSuccessLoginDefaultUrl());
        return successRedirectHandler;
    }

    @Bean
    public SimpleUrlAuthenticationFailureHandler failureRedirectHandler() {
        SimpleUrlAuthenticationFailureHandler failureHandler = new SimpleUrlAuthenticationFailureHandler();
        if (!this.samlConfigBean().getFailedLoginDefaultUrl().isEmpty()) {
            failureHandler.setDefaultFailureUrl(this.samlConfigBean().getFailedLoginDefaultUrl());
        }
        return failureHandler;
    }

    @Bean
    public SimpleUrlLogoutSuccessHandler successLogoutHandler() {
        SimpleUrlLogoutSuccessHandler successLogoutHandler = new SimpleUrlLogoutSuccessHandler();
        successLogoutHandler.setDefaultTargetUrl(this.samlConfigBean().getSuccessLogoutUrl());
        return successLogoutHandler;
    }

    @Bean
    public AuthenticationManager authenticationManagerBean() throws Exception {
        return super.authenticationManagerBean();
    }

    protected void configure(AuthenticationManagerBuilder auth) throws Exception {
        auth.authenticationProvider((AuthenticationProvider)this.samlAuthenticationProvider);
    }

    @Bean
    public SAMLDefaultLogger samlLogger() {
        return new SAMLDefaultLogger();
    }

    @Bean
    public KeyManager keyManager() {
        return new JKSKeyManager(this.samlConfigBean().getKeystoreResource(), this.samlConfigBean().getKeystorePassword(), (Map)ImmutableMap.of((Object)this.samlConfigBean().getKeystoreAlias(), (Object)this.samlConfigBean().getKeystorePrivateKeyPassword()), this.samlConfigBean().getKeystoreAlias());
    }

    @Bean
    public SAMLDiscovery samlIDPDiscovery() {
        return new SAMLDiscovery();
    }

    @Bean
    public MetadataDisplayFilter metadataDisplayFilter() {
        return new MetadataDisplayFilter();
    }

    @Bean
    public TLSProtocolConfigurer tlsProtocolConfigurer() {
        return new TLSProtocolConfigurer();
    }

    @Bean
    public ProtocolSocketFactory protocolSocketFactory() {
        return new TLSProtocolSocketFactory(this.keyManager(), null, "default");
    }

    @Bean
    public Protocol protocol() {
        return new Protocol("https", this.protocolSocketFactory(), 443);
    }

    @Bean
    public MethodInvokingFactoryBean socketFactoryInitialization() {
        MethodInvokingFactoryBean methodInvokingFactoryBean = new MethodInvokingFactoryBean();
        methodInvokingFactoryBean.setTargetClass(Protocol.class);
        methodInvokingFactoryBean.setTargetMethod("registerProtocol");
        methodInvokingFactoryBean.setArguments(new Object[]{"https", this.protocol()});
        return methodInvokingFactoryBean;
    }

    @Bean
    public CachingMetadataManager metadata() throws MetadataProviderException {
        HTTPMetadataProvider httpMetadataProvider = new HTTPMetadataProvider(new Timer(true), this.httpClient(), this.getMetdataUrl());
        httpMetadataProvider.setParserPool((ParserPool)this.parserPool());
        ExtendedMetadataDelegate extendedMetadataDelegate = new ExtendedMetadataDelegate((MetadataProvider)httpMetadataProvider);
        extendedMetadataDelegate.setMetadataTrustCheck(false);
        return new CachingMetadataManager((List)ImmutableList.of((Object)extendedMetadataDelegate));
    }

    @Bean
    public SAMLAuthenticationProvider samlAuthenticationProvider() {
        SAMLAuthenticationProvider samlAuthenticationProvider = new SAMLAuthenticationProvider();
        if (this.samlConfigBean().getSamlUserDetailsService() != null) {
            samlAuthenticationProvider.setUserDetails(this.samlConfigBean().getSamlUserDetailsService());
        }
        return samlAuthenticationProvider;
    }

    @Bean
    public SAMLContextProviderImpl contextProvider() {
        return new SAMLContextProviderImpl();
    }

    @Bean
    public SAMLProcessingFilter samlProcessingFilter() throws Exception {
        SAMLProcessingFilter samlWebSSOProcessingFilter = new SAMLProcessingFilter();
        samlWebSSOProcessingFilter.setAuthenticationManager(this.authenticationManager());
        samlWebSSOProcessingFilter.setAuthenticationSuccessHandler((AuthenticationSuccessHandler)this.successRedirectHandler());
        samlWebSSOProcessingFilter.setAuthenticationFailureHandler((AuthenticationFailureHandler)this.failureRedirectHandler());
        return samlWebSSOProcessingFilter;
    }

    @Bean
    public SAMLWebSSOHoKProcessingFilter samlWebSSOHoKProcessingFilter() throws Exception {
        SAMLWebSSOHoKProcessingFilter samlWebSSOHoKProcessingFilter = new SAMLWebSSOHoKProcessingFilter();
        samlWebSSOHoKProcessingFilter.setAuthenticationSuccessHandler((AuthenticationSuccessHandler)this.successRedirectHandler());
        samlWebSSOHoKProcessingFilter.setAuthenticationManager(this.authenticationManager());
        samlWebSSOHoKProcessingFilter.setAuthenticationFailureHandler((AuthenticationFailureHandler)this.failureRedirectHandler());
        return samlWebSSOHoKProcessingFilter;
    }

    @Bean
    public SecurityContextLogoutHandler logoutHandler() {
        SecurityContextLogoutHandler logoutHandler = new SecurityContextLogoutHandler();
        logoutHandler.setInvalidateHttpSession(true);
        logoutHandler.setClearAuthentication(true);
        return logoutHandler;
    }

    @Bean
    public SAMLLogoutFilter samlLogoutFilter() {
        return new SAMLLogoutFilter((LogoutSuccessHandler)this.successLogoutHandler(), new LogoutHandler[]{this.logoutHandler()}, new LogoutHandler[]{this.logoutHandler()});
    }

    @Bean
    public SAMLLogoutProcessingFilter samlLogoutProcessingFilter() {
        return new SAMLLogoutProcessingFilter((LogoutSuccessHandler)this.successLogoutHandler(), new LogoutHandler[]{this.logoutHandler()});
    }

    @Bean
    public SAMLProcessorImpl processor() {
        return new SAMLProcessorImpl((Collection)ImmutableList.of((Object)this.redirectDeflateBinding(), (Object)this.postBinding(), (Object)this.artifactBinding(), (Object)this.soapBinding(), (Object)this.paosBinding()));
    }

    @Bean
    public WebSSOProfileConsumer webSSOprofileConsumer() {
        return new WebSSOProfileConsumerImpl();
    }

    @Bean
    public WebSSOProfileConsumerHoKImpl hokWebSSOprofileConsumer() {
        return new WebSSOProfileConsumerHoKImpl();
    }

    @Bean
    public WebSSOProfile webSSOprofile() {
        return new WebSSOProfileImpl();
    }

    @Bean
    public WebSSOProfileConsumerHoKImpl hokWebSSOProfile() {
        return new WebSSOProfileConsumerHoKImpl();
    }

    @Bean
    public WebSSOProfileECPImpl ecpprofile() {
        return new WebSSOProfileECPImpl();
    }

    @Bean
    public SingleLogoutProfile logoutprofile() {
        return new SingleLogoutProfileImpl();
    }

    @Bean
    public HTTPPostBinding postBinding() {
        return new HTTPPostBinding((ParserPool)this.parserPool(), this.velocityEngine());
    }

    @Bean
    public HTTPRedirectDeflateBinding redirectDeflateBinding() {
        return new HTTPRedirectDeflateBinding((ParserPool)this.parserPool());
    }

    @Bean
    public HTTPArtifactBinding artifactBinding() {
        ArtifactResolutionProfileImpl artifactResolutionProfile = new ArtifactResolutionProfileImpl(this.httpClient());
        artifactResolutionProfile.setProcessor((SAMLProcessor)new SAMLProcessorImpl((SAMLBinding)this.soapBinding()));
        return new HTTPArtifactBinding((ParserPool)this.parserPool(), this.velocityEngine(), (ArtifactResolutionProfile)artifactResolutionProfile);
    }

    @Bean
    public HTTPSOAP11Binding soapBinding() {
        return new HTTPSOAP11Binding((ParserPool)this.parserPool());
    }

    @Bean
    public HTTPPAOS11Binding paosBinding() {
        return new HTTPPAOS11Binding((ParserPool)this.parserPool());
    }

    @Bean
    public VelocityEngine velocityEngine() {
        return VelocityFactory.getEngine();
    }

    @Bean(initMethod="initialize")
    public StaticBasicParserPool parserPool() {
        return new StaticBasicParserPool();
    }

    @Bean
    public ParserPoolHolder parserPoolHolder() {
        return new ParserPoolHolder();
    }
}

