/*
 * Decompiled with CFR 0.152.
 */
package com.github.choonchernlim.security.adfs.saml2;

import com.github.choonchernlim.security.adfs.saml2.SAMLConfigBean;
import java.util.Set;
import org.springframework.core.io.Resource;
import org.springframework.security.saml.userdetails.SAMLUserDetailsService;

public final class SAMLConfigBeanBuilder {
    private String spMetadataBaseUrl;
    private String adfsHostName;
    private Resource keystoreResource;
    private String keystoreAlias;
    private String keystorePassword;
    private String keystorePrivateKeyPassword;
    private String successLoginDefaultUrl;
    private String successLogoutUrl;
    private String failedLoginDefaultUrl;
    private SAMLUserDetailsService samlUserDetailsService;
    private Set<String> authnContexts;

    public SAMLConfigBeanBuilder setSpMetadataBaseUrl(String spMetadataBaseUrl) {
        this.spMetadataBaseUrl = spMetadataBaseUrl;
        return this;
    }

    public SAMLConfigBeanBuilder setAdfsHostName(String adfsHostName) {
        this.adfsHostName = adfsHostName;
        return this;
    }

    public SAMLConfigBeanBuilder setKeystoreResource(Resource keystoreResource) {
        this.keystoreResource = keystoreResource;
        return this;
    }

    public SAMLConfigBeanBuilder setKeystoreAlias(String keystoreAlias) {
        this.keystoreAlias = keystoreAlias;
        return this;
    }

    public SAMLConfigBeanBuilder setKeystorePassword(String keystorePassword) {
        this.keystorePassword = keystorePassword;
        return this;
    }

    public SAMLConfigBeanBuilder setKeystorePrivateKeyPassword(String keystorePrivateKeyPassword) {
        this.keystorePrivateKeyPassword = keystorePrivateKeyPassword;
        return this;
    }

    public SAMLConfigBeanBuilder setSuccessLoginDefaultUrl(String successLoginDefaultUrl) {
        this.successLoginDefaultUrl = successLoginDefaultUrl;
        return this;
    }

    public SAMLConfigBeanBuilder setSuccessLogoutUrl(String successLogoutUrl) {
        this.successLogoutUrl = successLogoutUrl;
        return this;
    }

    public SAMLConfigBeanBuilder setFailedLoginDefaultUrl(String failedLoginDefaultUrl) {
        this.failedLoginDefaultUrl = failedLoginDefaultUrl;
        return this;
    }

    public SAMLConfigBeanBuilder setSamlUserDetailsService(SAMLUserDetailsService samlUserDetailsService) {
        this.samlUserDetailsService = samlUserDetailsService;
        return this;
    }

    public SAMLConfigBeanBuilder setAuthnContexts(Set<String> authnContexts) {
        this.authnContexts = authnContexts;
        return this;
    }

    public SAMLConfigBean createSAMLConfigBean() {
        return new SAMLConfigBean(this.spMetadataBaseUrl, this.adfsHostName, this.keystoreResource, this.keystoreAlias, this.keystorePassword, this.keystorePrivateKeyPassword, this.successLoginDefaultUrl, this.successLogoutUrl, this.failedLoginDefaultUrl, this.samlUserDetailsService, this.authnContexts);
    }
}

