/*
 * Decompiled with CFR 0.152.
 */
package com.github.choonchernlim.security.adfs.saml2;

import com.github.choonchernlim.betterPreconditions.preconditions.ObjectPreconditions;
import com.github.choonchernlim.betterPreconditions.preconditions.PreconditionFactory;
import com.github.choonchernlim.betterPreconditions.preconditions.StringPreconditions;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.springframework.core.io.Resource;
import org.springframework.security.saml.userdetails.SAMLUserDetailsService;

public final class SAMLConfigBean {
    private final String spMetadataBaseUrl;
    private final String adfsHostName;
    private final Resource keystoreResource;
    private final String keystoreAlias;
    private final String keystorePassword;
    private final String keystorePrivateKeyPassword;
    private final String successLoginDefaultUrl;
    private final String successLogoutUrl;
    private final String failedLoginDefaultUrl;
    private final SAMLUserDetailsService samlUserDetailsService;
    private final Set<String> authnContexts;

    SAMLConfigBean(String spMetadataBaseUrl, String adfsHostName, Resource keystoreResource, String keystoreAlias, String keystorePassword, String keystorePrivateKeyPassword, String successLoginDefaultUrl, String successLogoutUrl, String failedLoginDefaultUrl, SAMLUserDetailsService samlUserDetailsService, Set<String> authnContexts) {
        this.spMetadataBaseUrl = (String)((StringPreconditions)PreconditionFactory.expect((String)spMetadataBaseUrl, (String)"Sp's metadata base URL").not()).toBeBlank().check();
        this.adfsHostName = (String)((StringPreconditions)PreconditionFactory.expect((String)adfsHostName, (String)"ADFS host name").not()).toBeBlank().check();
        this.keystoreResource = (Resource)((ObjectPreconditions)((ObjectPreconditions)PreconditionFactory.expect((Object)keystoreResource, (String)"Key store").not()).toBeNull()).check();
        this.keystoreAlias = (String)((StringPreconditions)PreconditionFactory.expect((String)keystoreAlias, (String)"Keystore alias").not()).toBeBlank().check();
        this.keystorePassword = (String)((StringPreconditions)PreconditionFactory.expect((String)keystorePassword, (String)"Keystore password").not()).toBeBlank().check();
        this.keystorePrivateKeyPassword = (String)((StringPreconditions)PreconditionFactory.expect((String)keystorePrivateKeyPassword, (String)"Keystore private key password").not()).toBeBlank().check();
        this.successLoginDefaultUrl = (String)((StringPreconditions)PreconditionFactory.expect((String)successLoginDefaultUrl, (String)"Success login URL").not()).toBeBlank().check();
        this.successLogoutUrl = (String)((StringPreconditions)PreconditionFactory.expect((String)successLogoutUrl, (String)"Success logout URL").not()).toBeBlank().check();
        this.failedLoginDefaultUrl = (String)Optional.fromNullable((Object)failedLoginDefaultUrl).or((Object)"");
        this.samlUserDetailsService = samlUserDetailsService;
        this.authnContexts = (Set)Optional.fromNullable(authnContexts).or((Object)ImmutableSet.of((Object)"urn:oasis:names:tc:SAML:2.0:ac:classes:Password"));
    }

    public String getSpMetadataBaseUrl() {
        return this.spMetadataBaseUrl;
    }

    public String getAdfsHostName() {
        return this.adfsHostName;
    }

    public Resource getKeystoreResource() {
        return this.keystoreResource;
    }

    public String getKeystoreAlias() {
        return this.keystoreAlias;
    }

    public String getKeystorePassword() {
        return this.keystorePassword;
    }

    public String getKeystorePrivateKeyPassword() {
        return this.keystorePrivateKeyPassword;
    }

    public String getSuccessLoginDefaultUrl() {
        return this.successLoginDefaultUrl;
    }

    public String getSuccessLogoutUrl() {
        return this.successLogoutUrl;
    }

    public String getFailedLoginDefaultUrl() {
        return this.failedLoginDefaultUrl;
    }

    public SAMLUserDetailsService getSamlUserDetailsService() {
        return this.samlUserDetailsService;
    }

    public Set<String> getAuthnContexts() {
        return this.authnContexts;
    }
}

