/*
 * Decompiled with CFR 0.152.
 */
package com.github.choonchernlim.security.adfs.saml2;

import com.github.choonchernlim.betterPreconditions.preconditions.PreconditionFactory;
import com.github.choonchernlim.betterPreconditions.preconditions.StringPreconditions;
import org.opensaml.Configuration;
import org.opensaml.xml.security.BasicSecurityConfiguration;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.security.saml.SAMLBootstrap;

public final class DefaultSAMLBootstrap
extends SAMLBootstrap {
    private final String signatureAlgorithmName;
    private final String signatureAlgorithmURI;
    private final String digestAlgorithmURI;

    public DefaultSAMLBootstrap() {
        this("RSA", "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256", "http://www.w3.org/2001/04/xmlenc#sha256");
    }

    public DefaultSAMLBootstrap(String signatureAlgorithmName, String signatureAlgorithmURI, String digestAlgorithmURI) {
        this.signatureAlgorithmName = (String)((StringPreconditions)PreconditionFactory.expect((String)signatureAlgorithmName, (String)"Signature algorithm name").not()).toBeBlank().check();
        this.signatureAlgorithmURI = (String)((StringPreconditions)PreconditionFactory.expect((String)signatureAlgorithmURI, (String)"Signature algorithm URI").not()).toBeBlank().check();
        this.digestAlgorithmURI = (String)((StringPreconditions)PreconditionFactory.expect((String)digestAlgorithmURI, (String)"Digest algorithm URI").not()).toBeBlank().check();
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        super.postProcessBeanFactory(beanFactory);
        BasicSecurityConfiguration config = (BasicSecurityConfiguration)Configuration.getGlobalSecurityConfiguration();
        config.registerSignatureAlgorithmURI(this.signatureAlgorithmName, this.signatureAlgorithmURI);
        config.setSignatureReferenceDigestMethod(this.digestAlgorithmURI);
    }
}

