/*
 * Decompiled with CFR 0.152.
 */
package com.chenhaiyang.plugin.mybatis.sensitive.type;

import com.chenhaiyang.plugin.mybatis.sensitive.type.SensitiveType;
import com.chenhaiyang.plugin.mybatis.sensitive.type.SensitiveTypeHandler;
import com.chenhaiyang.plugin.mybatis.sensitive.type.handler.AddressSensitiveHandler;
import com.chenhaiyang.plugin.mybatis.sensitive.type.handler.BandCardSensitiveHandler;
import com.chenhaiyang.plugin.mybatis.sensitive.type.handler.CnapsSensitiveHandler;
import com.chenhaiyang.plugin.mybatis.sensitive.type.handler.DafaultSensitiveHandler;
import com.chenhaiyang.plugin.mybatis.sensitive.type.handler.EmailSensitiveHandler;
import com.chenhaiyang.plugin.mybatis.sensitive.type.handler.FixedPhoneSensitiveHandler;
import com.chenhaiyang.plugin.mybatis.sensitive.type.handler.IDCardSensitiveHandler;
import com.chenhaiyang.plugin.mybatis.sensitive.type.handler.MobilePhoneSensitiveHandler;
import com.chenhaiyang.plugin.mybatis.sensitive.type.handler.NameSensitiveHandler;
import com.chenhaiyang.plugin.mybatis.sensitive.type.handler.NoneSensitiveHandler;
import com.chenhaiyang.plugin.mybatis.sensitive.type.handler.PaySignNoSensitiveHandler;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class SensitiveTypeRegisty {
    private static final Map<SensitiveType, SensitiveTypeHandler> HANDLER_REGISTY = new ConcurrentHashMap<SensitiveType, SensitiveTypeHandler>();

    public static void put(SensitiveTypeHandler sensitiveTypeHandler) {
        HANDLER_REGISTY.put(sensitiveTypeHandler.getSensitiveType(), sensitiveTypeHandler);
    }

    public static SensitiveTypeHandler get(SensitiveType sensitiveType) {
        SensitiveTypeHandler sensitiveTypeHandler = HANDLER_REGISTY.get((Object)sensitiveType);
        if (sensitiveTypeHandler == null) {
            throw new IllegalArgumentException("none sensitiveTypeHandler be found!, type:" + sensitiveType.name());
        }
        return sensitiveTypeHandler;
    }

    public static boolean alreadyBeSentisived(Object src) {
        return src == null || src.toString().indexOf("*") > 0;
    }

    static {
        HANDLER_REGISTY.put(SensitiveType.NONE, new NoneSensitiveHandler());
        HANDLER_REGISTY.put(SensitiveType.DEFAUL, new DafaultSensitiveHandler());
        HANDLER_REGISTY.put(SensitiveType.CHINESE_NAME, new NameSensitiveHandler());
        HANDLER_REGISTY.put(SensitiveType.ID_CARD, new IDCardSensitiveHandler());
        HANDLER_REGISTY.put(SensitiveType.MOBILE_PHONE, new MobilePhoneSensitiveHandler());
        HANDLER_REGISTY.put(SensitiveType.ADDRESS, new AddressSensitiveHandler());
        HANDLER_REGISTY.put(SensitiveType.EMAIL, new EmailSensitiveHandler());
        HANDLER_REGISTY.put(SensitiveType.BANK_CARD, new BandCardSensitiveHandler());
        HANDLER_REGISTY.put(SensitiveType.FIXED_PHONE, new FixedPhoneSensitiveHandler());
        HANDLER_REGISTY.put(SensitiveType.CNAPS_CODE, new CnapsSensitiveHandler());
        HANDLER_REGISTY.put(SensitiveType.PAY_SIGN_NO, new PaySignNoSensitiveHandler());
    }
}

