/*
 * Decompiled with CFR 0.152.
 */
package com.chenhaiyang.plugin.mybatis.sensitive.interceptor;

import com.chenhaiyang.plugin.mybatis.sensitive.Encrypt;
import com.chenhaiyang.plugin.mybatis.sensitive.annotation.EncryptField;
import com.chenhaiyang.plugin.mybatis.sensitive.annotation.SensitiveEncryptEnabled;
import com.chenhaiyang.plugin.mybatis.sensitive.annotation.SensitiveField;
import com.chenhaiyang.plugin.mybatis.sensitive.annotation.SensitiveJSONField;
import com.chenhaiyang.plugin.mybatis.sensitive.annotation.SensitiveJSONFieldKey;
import com.chenhaiyang.plugin.mybatis.sensitive.type.SensitiveType;
import com.chenhaiyang.plugin.mybatis.sensitive.type.SensitiveTypeRegisty;
import com.chenhaiyang.plugin.mybatis.sensitive.utils.JsonUtils;
import com.chenhaiyang.plugin.mybatis.sensitive.utils.PluginUtils;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.apache.ibatis.session.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Intercepts(value={@Signature(type=StatementHandler.class, method="prepare", args={Connection.class, Integer.class})})
public class SensitiveAndEncryptWriteInterceptor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(SensitiveAndEncryptWriteInterceptor.class);
    private static final String MAPPEDSTATEMENT = "delegate.mappedStatement";
    private static final String BOUND_SQL = "delegate.boundSql";
    private Encrypt encrypt;

    public SensitiveAndEncryptWriteInterceptor(Encrypt encrypt) {
        Objects.requireNonNull(encrypt, "encrypt should not be null!");
        this.encrypt = encrypt;
    }

    public Object intercept(Invocation invocation) throws Throwable {
        SensitiveEncryptEnabled sensitiveEncryptEnabled;
        StatementHandler statementHandler = (StatementHandler)PluginUtils.realTarget(invocation.getTarget());
        MetaObject metaObject = SystemMetaObject.forObject((Object)statementHandler);
        MappedStatement mappedStatement = (MappedStatement)metaObject.getValue(MAPPEDSTATEMENT);
        SqlCommandType commandType = mappedStatement.getSqlCommandType();
        BoundSql boundSql = (BoundSql)metaObject.getValue(BOUND_SQL);
        Object params = boundSql.getParameterObject();
        if (params instanceof Map) {
            return invocation.proceed();
        }
        SensitiveEncryptEnabled sensitiveEncryptEnabled2 = sensitiveEncryptEnabled = params != null ? params.getClass().getAnnotation(SensitiveEncryptEnabled.class) : null;
        if (sensitiveEncryptEnabled != null && sensitiveEncryptEnabled.value()) {
            this.handleParameters(mappedStatement.getConfiguration(), boundSql, params, commandType);
        }
        return invocation.proceed();
    }

    private void handleParameters(Configuration configuration, BoundSql boundSql, Object param, SqlCommandType commandType) throws Exception {
        HashMap<String, Object> newValues = new HashMap<String, Object>(16);
        MetaObject metaObject = configuration.newMetaObject(param);
        for (Field field : param.getClass().getDeclaredFields()) {
            Object value;
            Object newValue = value = metaObject.getValue(field.getName());
            if (value instanceof CharSequence) {
                newValue = this.handleEncryptField(field, newValue);
                if (this.isWriteCommand(commandType) && !SensitiveTypeRegisty.alreadyBeSentisived(newValue)) {
                    newValue = this.handleSensitiveField(field, newValue);
                    newValue = this.handleSensitiveJSONField(field, newValue);
                }
            }
            if (value == null || newValue == null || value.equals(newValue)) continue;
            newValues.put(field.getName(), newValue);
        }
        for (Map.Entry entry : newValues.entrySet()) {
            boundSql.setAdditionalParameter((String)entry.getKey(), entry.getValue());
        }
    }

    private boolean isWriteCommand(SqlCommandType commandType) {
        return SqlCommandType.UPDATE.equals((Object)commandType) || SqlCommandType.INSERT.equals((Object)commandType);
    }

    private Object handleEncryptField(Field field, Object value) {
        EncryptField encryptField = field.getAnnotation(EncryptField.class);
        Object newValue = value;
        if (encryptField != null && value != null) {
            newValue = this.encrypt.encrypt(value.toString());
        }
        return newValue;
    }

    private Object handleSensitiveField(Field field, Object value) {
        SensitiveField sensitiveField = field.getAnnotation(SensitiveField.class);
        Object newValue = value;
        if (sensitiveField != null && value != null) {
            newValue = SensitiveTypeRegisty.get(sensitiveField.value()).handle(value);
        }
        return newValue;
    }

    private Object handleSensitiveJSONField(Field field, Object value) {
        SensitiveJSONField sensitiveJSONField = field.getAnnotation(SensitiveJSONField.class);
        Object newValue = value;
        if (sensitiveJSONField != null && value != null) {
            newValue = this.processJsonField(newValue, sensitiveJSONField);
        }
        return newValue;
    }

    private Object processJsonField(Object newValue, SensitiveJSONField sensitiveJSONField) {
        try {
            SensitiveJSONFieldKey[] keys;
            Map<String, Object> map = JsonUtils.parseToObjectMap(newValue.toString());
            for (SensitiveJSONFieldKey jsonFieldKey : keys = sensitiveJSONField.sensitivelist()) {
                String key = jsonFieldKey.key();
                SensitiveType sensitiveType = jsonFieldKey.type();
                Object oldData = map.get(key);
                if (oldData == null) continue;
                String newData = SensitiveTypeRegisty.get(sensitiveType).handle(oldData);
                map.put(key, newData);
            }
            return JsonUtils.parseMaptoJSONString(map);
        }
        catch (Throwable e) {
            log.error("\u8131\u654fjson\u4e32\u65f6\u5931\u8d25\uff0ccause : {}", (Object)e.getMessage(), (Object)e);
            return newValue;
        }
    }

    public Object plugin(Object o) {
        return Plugin.wrap((Object)o, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }
}

