/*
 * Decompiled with CFR 0.152.
 */
package com.chenhaiyang.plugin.mybatis.sensitive.interceptor;

import com.chenhaiyang.plugin.mybatis.sensitive.Encrypt;
import com.chenhaiyang.plugin.mybatis.sensitive.annotation.EncryptField;
import com.chenhaiyang.plugin.mybatis.sensitive.annotation.SensitiveBinded;
import com.chenhaiyang.plugin.mybatis.sensitive.annotation.SensitiveEncryptEnabled;
import com.chenhaiyang.plugin.mybatis.sensitive.type.SensitiveType;
import com.chenhaiyang.plugin.mybatis.sensitive.type.SensitiveTypeRegisty;
import com.chenhaiyang.plugin.mybatis.sensitive.utils.PluginUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.apache.ibatis.executor.resultset.ResultSetHandler;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Intercepts(value={@Signature(type=ResultSetHandler.class, method="handleResultSets", args={Statement.class})})
public class DecryptReadInterceptor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(DecryptReadInterceptor.class);
    private static final String MAPPED_STATEMENT = "mappedStatement";
    private Encrypt encrypt;

    public DecryptReadInterceptor(Encrypt encrypt) {
        Objects.requireNonNull(encrypt, "encrypt should not be null!");
        this.encrypt = encrypt;
    }

    public Object intercept(Invocation invocation) throws Throwable {
        List results = (List)invocation.proceed();
        if (results.isEmpty()) {
            return results;
        }
        ResultSetHandler statementHandler = (ResultSetHandler)PluginUtils.realTarget(invocation.getTarget());
        MetaObject metaObject = SystemMetaObject.forObject((Object)statementHandler);
        MappedStatement mappedStatement = (MappedStatement)metaObject.getValue(MAPPED_STATEMENT);
        ResultMap resultMap = mappedStatement.getResultMaps().isEmpty() ? null : (ResultMap)mappedStatement.getResultMaps().get(0);
        Object result0 = results.get(0);
        SensitiveEncryptEnabled sensitiveEncryptEnabled = result0.getClass().getAnnotation(SensitiveEncryptEnabled.class);
        if (sensitiveEncryptEnabled == null || !sensitiveEncryptEnabled.value()) {
            return results;
        }
        Map<String, EncryptField> sensitiveFieldMap = this.getSensitiveByResultMap(resultMap);
        Map<String, SensitiveBinded> sensitiveBindedMap = this.getSensitiveBindedByResultMap(resultMap);
        if (sensitiveBindedMap.isEmpty() && sensitiveFieldMap.isEmpty()) {
            return results;
        }
        for (Object obj : results) {
            String property;
            MetaObject objMetaObject = mappedStatement.getConfiguration().newMetaObject(obj);
            for (Map.Entry<String, EncryptField> entry : sensitiveFieldMap.entrySet()) {
                property = entry.getKey();
                String value = (String)objMetaObject.getValue(property);
                if (value == null) continue;
                String decryptValue = this.encrypt.decrypt(value);
                objMetaObject.setValue(property, (Object)decryptValue);
            }
            for (Map.Entry<String, Annotation> entry : sensitiveBindedMap.entrySet()) {
                property = entry.getKey();
                SensitiveBinded sensitiveBinded = (SensitiveBinded)entry.getValue();
                String bindPropety = sensitiveBinded.bindField();
                SensitiveType sensitiveType = sensitiveBinded.value();
                try {
                    String value = (String)objMetaObject.getValue(bindPropety);
                    String resultValue = SensitiveTypeRegisty.get(sensitiveType).handle(value);
                    objMetaObject.setValue(property, (Object)resultValue);
                }
                catch (Exception exception) {}
            }
        }
        return results;
    }

    private Map<String, SensitiveBinded> getSensitiveBindedByResultMap(ResultMap resultMap) {
        if (resultMap == null) {
            return new HashMap<String, SensitiveBinded>(16);
        }
        HashMap<String, SensitiveBinded> sensitiveBindedMap = new HashMap<String, SensitiveBinded>(16);
        Class clazz = resultMap.getType();
        for (Field field : clazz.getDeclaredFields()) {
            SensitiveBinded sensitiveBinded = field.getAnnotation(SensitiveBinded.class);
            if (sensitiveBinded == null) continue;
            sensitiveBindedMap.put(field.getName(), sensitiveBinded);
        }
        return sensitiveBindedMap;
    }

    private Map<String, EncryptField> getSensitiveByResultMap(ResultMap resultMap) {
        if (resultMap == null) {
            return new HashMap<String, EncryptField>(16);
        }
        return this.getSensitiveByType(resultMap.getType());
    }

    private Map<String, EncryptField> getSensitiveByType(Class<?> clazz) {
        HashMap<String, EncryptField> sensitiveFieldMap = new HashMap<String, EncryptField>(16);
        for (Field field : clazz.getDeclaredFields()) {
            EncryptField sensitiveField = field.getAnnotation(EncryptField.class);
            if (sensitiveField == null) continue;
            sensitiveFieldMap.put(field.getName(), sensitiveField);
        }
        return sensitiveFieldMap;
    }

    public Object plugin(Object o) {
        return Plugin.wrap((Object)o, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }
}

