/*
 * Decompiled with CFR 0.152.
 */
package com.chenhaiyang.plugin.mybatis.sensitive.encrypt;

import com.chenhaiyang.plugin.mybatis.sensitive.Encrypt;
import com.chenhaiyang.plugin.mybatis.sensitive.type.SensitiveType;
import com.chenhaiyang.plugin.mybatis.sensitive.type.SensitiveTypeHandler;
import com.chenhaiyang.plugin.mybatis.sensitive.type.SensitiveTypeRegisty;
import com.chenhaiyang.plugin.mybatis.sensitive.utils.Hex;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AesSupport
implements Encrypt {
    private static final Logger log = LoggerFactory.getLogger(AesSupport.class);
    private static final String KEY_ALGORITHM = "AES";
    private static final String DEFAULT_CIPHER_ALGORITHM = "AES/ECB/PKCS5Padding";
    private String password;
    private SecretKeySpec secretKeySpec;
    private SensitiveTypeHandler sensitiveTypeHandler = SensitiveTypeRegisty.get(SensitiveType.DEFAUL);

    public AesSupport(String password) throws NoSuchAlgorithmException {
        if (StringUtils.isEmpty((CharSequence)password)) {
            throw new IllegalArgumentException("password should not be null!");
        }
        this.password = password;
        this.secretKeySpec = AesSupport.getSecretKey(password);
    }

    @Override
    public String encrypt(String value) {
        try {
            Cipher cipher = Cipher.getInstance(DEFAULT_CIPHER_ALGORITHM);
            cipher.init(1, this.secretKeySpec);
            byte[] content = value.getBytes("UTF-8");
            byte[] encryptData = cipher.doFinal(content);
            return Hex.bytesToHexString(encryptData);
        }
        catch (Exception e) {
            log.error("AES\u52a0\u5bc6\u65f6\u51fa\u73b0\u95ee\u9898\uff0c\u5bc6\u94a5\u4e3a\uff1a{}", (Object)this.sensitiveTypeHandler.handle(this.password));
            throw new IllegalStateException("AES\u52a0\u5bc6\u65f6\u51fa\u73b0\u95ee\u9898" + e.getMessage(), e);
        }
    }

    @Override
    public String decrypt(String value) {
        if (StringUtils.isEmpty((CharSequence)value)) {
            return "";
        }
        try {
            byte[] encryptData = Hex.hexStringToBytes(value);
            Cipher cipher = Cipher.getInstance(DEFAULT_CIPHER_ALGORITHM);
            cipher.init(2, this.secretKeySpec);
            byte[] content = cipher.doFinal(encryptData);
            return new String(content, "UTF-8");
        }
        catch (Exception e) {
            log.error("AES\u89e3\u5bc6\u65f6\u51fa\u73b0\u95ee\u9898\uff0c\u5bc6\u94a5\u4e3a:{},\u5bc6\u6587\u4e3a\uff1a{}", (Object)this.sensitiveTypeHandler.handle(this.password), (Object)value);
            throw new IllegalStateException("AES\u89e3\u5bc6\u65f6\u51fa\u73b0\u95ee\u9898" + e.getMessage(), e);
        }
    }

    private static SecretKeySpec getSecretKey(String password) throws NoSuchAlgorithmException {
        KeyGenerator kg = KeyGenerator.getInstance(KEY_ALGORITHM);
        SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
        random.setSeed(password.getBytes());
        kg.init(128, random);
        SecretKey secretKey = kg.generateKey();
        return new SecretKeySpec(secretKey.getEncoded(), KEY_ALGORITHM);
    }
}

