/*
 * Decompiled with CFR 0.152.
 */
package com.github.chengyuxing.sql.spring.autoconfigure;

import com.github.chengyuxing.common.script.IPipe;
import com.github.chengyuxing.common.utils.ReflectUtil;
import com.github.chengyuxing.sql.Baki;
import com.github.chengyuxing.sql.XQLFileManager;
import com.github.chengyuxing.sql.page.PageHelperProvider;
import com.github.chengyuxing.sql.spring.autoconfigure.BakiProperties;
import com.github.chengyuxing.sql.spring.autoconfigure.SpringManagedBaki;
import com.github.chengyuxing.sql.spring.autoconfigure.Tx;
import com.github.chengyuxing.sql.spring.autoconfigure.XQLFileManagerProperties;
import com.github.chengyuxing.sql.support.SqlInterceptor;
import com.github.chengyuxing.sql.support.StatementValueHandler;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnSingleCandidate;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Configuration
@ConditionalOnClass(value={Baki.class})
@ConditionalOnSingleCandidate(value=DataSource.class)
@EnableConfigurationProperties(value={BakiProperties.class, XQLFileManagerProperties.class})
@AutoConfigureAfter(value={DataSourceAutoConfiguration.class})
public class BakiAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(BakiAutoConfiguration.class);
    public static final String XQL_CONFIG_LOCATION_NAME = "xql.config.location";
    private final DataSource dataSource;
    private final BakiProperties bakiProperties;
    private final PlatformTransactionManager transactionManager;
    private final ApplicationArguments applicationArguments;

    public BakiAutoConfiguration(DataSource dataSource, BakiProperties bakiProperties, @Autowired(required=false) PlatformTransactionManager transactionManager, ApplicationArguments applicationArguments) {
        this.dataSource = dataSource;
        this.bakiProperties = bakiProperties;
        this.transactionManager = transactionManager;
        this.applicationArguments = applicationArguments;
    }

    @Bean
    @ConditionalOnMissingBean
    public XQLFileManager xqlFileManager() {
        if (this.applicationArguments.containsOption(XQL_CONFIG_LOCATION_NAME)) {
            XQLFileManager xqlFileManager = new XQLFileManager((String)this.applicationArguments.getOptionValues(XQL_CONFIG_LOCATION_NAME).get(0));
            xqlFileManager.init();
            return xqlFileManager;
        }
        XQLFileManagerProperties properties = this.bakiProperties.getXqlFileManager();
        XQLFileManager xqlFileManager = new XQLFileManager();
        if (!ObjectUtils.isEmpty((Object)properties)) {
            if (!ObjectUtils.isEmpty((Object)properties.getConfigLocation())) {
                xqlFileManager = new XQLFileManager(properties.getConfigLocation());
            }
            if (!ObjectUtils.isEmpty(properties.getFiles())) {
                xqlFileManager.setFiles(properties.getFiles());
            }
            if (!ObjectUtils.isEmpty(properties.getConstants())) {
                xqlFileManager.setConstants(properties.getConstants());
            }
            if (!ObjectUtils.isEmpty(properties.getPipes())) {
                HashMap<String, Object> pipeInstances = new HashMap<String, Object>();
                try {
                    for (Map.Entry<String, Class<? extends IPipe>> e : properties.getPipes().entrySet()) {
                        pipeInstances.put(e.getKey(), ReflectUtil.getInstance(e.getValue(), (Object[])new Object[0]));
                    }
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    throw new IllegalStateException("create pipe instance error: ", e);
                }
                xqlFileManager.setPipeInstances(pipeInstances);
            }
            if (StringUtils.hasText((String)properties.getCharset())) {
                xqlFileManager.setCharset(Charset.forName(properties.getCharset()));
            }
            if (StringUtils.hasLength((String)properties.getDelimiter())) {
                xqlFileManager.setDelimiter(properties.getDelimiter());
            }
            if (this.bakiProperties.getNamedParamPrefix() != ' ') {
                xqlFileManager.setNamedParamPrefix(Character.valueOf(this.bakiProperties.getNamedParamPrefix()));
            }
        }
        xqlFileManager.init();
        return xqlFileManager;
    }

    @Bean
    @ConditionalOnMissingBean
    public SpringManagedBaki baki() throws RuntimeException {
        SpringManagedBaki baki = new SpringManagedBaki(this.dataSource);
        if (ObjectUtils.isEmpty((Object)this.bakiProperties)) {
            return baki;
        }
        XQLFileManager xqlFileManager = this.xqlFileManager();
        xqlFileManager.setDatabaseId(baki.databaseId());
        baki.setXqlFileManager(xqlFileManager);
        baki.setBatchSize(this.bakiProperties.getBatchSize());
        if (this.bakiProperties.getNamedParamPrefix() != ' ') {
            baki.setNamedParamPrefix(this.bakiProperties.getNamedParamPrefix());
        }
        baki.setReloadXqlOnGet(this.bakiProperties.isReloadXqlOnGet());
        if (!ObjectUtils.isEmpty(this.bakiProperties.getGlobalPageHelperProvider())) {
            try {
                PageHelperProvider pageHelperProvider = (PageHelperProvider)ReflectUtil.getInstance(this.bakiProperties.getGlobalPageHelperProvider(), (Object[])new Object[0]);
                baki.setGlobalPageHelperProvider(pageHelperProvider);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new IllegalStateException("configure globalPageHelperProvider error: ", e);
            }
        }
        if (!ObjectUtils.isEmpty(this.bakiProperties.getSqlInterceptor())) {
            try {
                SqlInterceptor sqlInterceptor = (SqlInterceptor)ReflectUtil.getInstance(this.bakiProperties.getSqlInterceptor(), (Object[])new Object[0]);
                baki.setSqlInterceptor(sqlInterceptor);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new IllegalStateException("configure sqlInterceptor error: ", e);
            }
        }
        if (!ObjectUtils.isEmpty(this.bakiProperties.getStatementValueHandler())) {
            try {
                StatementValueHandler statementValueHandler = (StatementValueHandler)ReflectUtil.getInstance(this.bakiProperties.getStatementValueHandler(), (Object[])new Object[0]);
                baki.setStatementValueHandler(statementValueHandler);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new IllegalStateException("configure statementValueHandler error: ", e);
            }
        }
        log.info("Baki initialized (Transaction managed by Spring)");
        return baki;
    }

    @Bean
    @ConditionalOnMissingBean
    public Tx tx() {
        return new Tx(this.transactionManager);
    }
}

