/*
 * Decompiled with CFR 0.152.
 */
package com.github.chengyuxing.sql.spring.autoconfigure;

import com.github.chengyuxing.sql.exceptions.TransactionException;
import java.util.function.Supplier;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

public class Tx {
    final PlatformTransactionManager transactionManager;

    public Tx(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public <T> T using(Supplier<T> supplier, TransactionDefinition definition) {
        TransactionStatus status = this.begin(definition);
        try {
            T result = supplier.get();
            this.commit(status);
            return result;
        }
        catch (Exception e) {
            this.rollback(status);
            throw new TransactionException("transaction is rollback.", (Throwable)e);
        }
    }

    public <T> T using(Supplier<T> supplier) {
        return this.using(supplier, (TransactionDefinition)new DefaultTransactionDefinition());
    }

    public void using(Runnable runnable, TransactionDefinition definition) {
        this.using(() -> {
            runnable.run();
            return 1;
        }, definition);
    }

    public void using(Runnable runnable) {
        this.using(runnable, (TransactionDefinition)new DefaultTransactionDefinition());
    }

    public TransactionStatus begin(TransactionDefinition definition) {
        return this.transactionManager.getTransaction(definition);
    }

    public TransactionStatus begin() {
        return this.begin((TransactionDefinition)new DefaultTransactionDefinition());
    }

    public void commit(TransactionStatus status) {
        this.transactionManager.commit(status);
    }

    public void rollback(TransactionStatus status) {
        this.transactionManager.rollback(status);
    }
}

