/*
 * Decompiled with CFR 0.152.
 */
package com.github.chengyuxing.sql.spring.autoconfigure;

import com.github.chengyuxing.sql.Baki;
import com.github.chengyuxing.sql.XQLFileManager;
import com.github.chengyuxing.sql.spring.autoconfigure.BakiProperties;
import com.github.chengyuxing.sql.spring.autoconfigure.SpringManagedBaki;
import com.github.chengyuxing.sql.spring.autoconfigure.XQLFileManagerProperties;
import java.nio.charset.Charset;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnSingleCandidate;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Configuration
@ConditionalOnClass(value={Baki.class})
@ConditionalOnSingleCandidate(value=DataSource.class)
@EnableConfigurationProperties(value={BakiProperties.class, XQLFileManagerProperties.class})
@AutoConfigureAfter(value={DataSourceAutoConfiguration.class})
public class BakiAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(BakiAutoConfiguration.class);
    private final DataSource dataSource;
    private final BakiProperties bakiProperties;

    public BakiAutoConfiguration(DataSource dataSource, BakiProperties bakiProperties) {
        this.dataSource = dataSource;
        this.bakiProperties = bakiProperties;
    }

    @Bean
    @ConditionalOnMissingBean
    public XQLFileManager xqlFileManager() {
        if (!ObjectUtils.isEmpty((Object)this.bakiProperties.getXqlFileManager())) {
            XQLFileManagerProperties properties = this.bakiProperties.getXqlFileManager();
            XQLFileManager xqlFileManager = new XQLFileManager();
            if (!ObjectUtils.isEmpty(properties.getFiles())) {
                xqlFileManager.setFiles(properties.getFiles());
            }
            if (!ObjectUtils.isEmpty(properties.getConstants())) {
                xqlFileManager.setConstants(properties.getConstants());
            }
            if (!ObjectUtils.isEmpty(properties.getPipes())) {
                xqlFileManager.setPipes(properties.getPipes());
            }
            if (StringUtils.hasText((String)properties.getCharset())) {
                xqlFileManager.setCharset(Charset.forName(properties.getCharset()));
            }
            if (StringUtils.hasLength((String)properties.getDelimiter())) {
                xqlFileManager.setDelimiter(properties.getDelimiter());
            }
            if (this.bakiProperties.getNamedParamPrefix() != ' ') {
                xqlFileManager.setNamedParamPrefix(this.bakiProperties.getNamedParamPrefix());
            }
            xqlFileManager.setCheckModified(properties.isCheckModified());
            xqlFileManager.setCheckPeriod(properties.getCheckPeriod());
            xqlFileManager.init();
            log.info("XQL File Manager initialized (xqlFileManager)");
            return xqlFileManager;
        }
        return null;
    }

    @Bean
    @ConditionalOnMissingBean
    public Baki baki() {
        SpringManagedBaki baki = new SpringManagedBaki(this.dataSource);
        baki.setDebugFullSql(this.bakiProperties.isDebugFullSql());
        baki.setCheckParameterType(this.bakiProperties.isCheckParameterType());
        baki.setStrictDynamicSqlArg(this.bakiProperties.isStrictDynamicSqlArg());
        XQLFileManager xqlFileManager = this.xqlFileManager();
        if (!ObjectUtils.isEmpty((Object)xqlFileManager)) {
            baki.setXqlFileManager(this.xqlFileManager());
            log.debug("baki external sql file support configured. ");
        }
        if (this.bakiProperties.getNamedParamPrefix() != ' ') {
            baki.setNamedParamPrefix(baki.getNamedParamPrefix());
        }
        if (!ObjectUtils.isEmpty(this.bakiProperties.getPageHelpers())) {
            baki.setPageHelpers(this.bakiProperties.getPageHelpers());
        }
        log.info("Baki initialized (Transaction managed by Spring)");
        return baki;
    }
}

