/*
 * Decompiled with CFR 0.152.
 */
package com.github.chengyuxing.sql.spring.autoconfigure;

import com.github.chengyuxing.common.script.IPipe;
import com.github.chengyuxing.sql.Baki;
import com.github.chengyuxing.sql.XQLFileManager;
import com.github.chengyuxing.sql.spring.autoconfigure.BakiProperties;
import com.github.chengyuxing.sql.spring.autoconfigure.SimpleTx;
import com.github.chengyuxing.sql.spring.autoconfigure.SpringManagedBaki;
import com.github.chengyuxing.sql.spring.autoconfigure.XQLFileManagerProperties;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnSingleCandidate;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Configuration
@ConditionalOnClass(value={Baki.class})
@ConditionalOnSingleCandidate(value=DataSource.class)
@EnableConfigurationProperties(value={BakiProperties.class, XQLFileManagerProperties.class})
@AutoConfigureAfter(value={DataSourceAutoConfiguration.class})
public class BakiAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(BakiAutoConfiguration.class);
    private final DataSource dataSource;
    private final BakiProperties bakiProperties;
    private final PlatformTransactionManager transactionManager;

    public BakiAutoConfiguration(DataSource dataSource, BakiProperties bakiProperties, @Autowired(required=false) PlatformTransactionManager transactionManager) {
        this.dataSource = dataSource;
        this.bakiProperties = bakiProperties;
        this.transactionManager = transactionManager;
    }

    @Bean
    @ConditionalOnMissingBean
    public XQLFileManager xqlFileManager() {
        XQLFileManagerProperties properties = this.bakiProperties.getXqlFileManager();
        XQLFileManager xqlFileManager = new XQLFileManager();
        if (!ObjectUtils.isEmpty((Object)properties)) {
            if (!ObjectUtils.isEmpty(properties.getFiles())) {
                xqlFileManager.setFiles(properties.getFiles());
            }
            if (!ObjectUtils.isEmpty(properties.getFilenames())) {
                xqlFileManager.setFilenames(properties.getFilenames());
            }
            if (!ObjectUtils.isEmpty(properties.getConstants())) {
                xqlFileManager.setConstants(properties.getConstants());
            }
            if (!ObjectUtils.isEmpty(properties.getPipes())) {
                HashMap<String, IPipe> pipeInstances = new HashMap<String, IPipe>();
                try {
                    for (Map.Entry<String, Class<? extends IPipe>> e : properties.getPipes().entrySet()) {
                        pipeInstances.put(e.getKey(), e.getValue().newInstance());
                    }
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new IllegalStateException("create pipe instance error: ", e);
                }
                xqlFileManager.setPipeInstances(pipeInstances);
            }
            if (StringUtils.hasText((String)properties.getCharset())) {
                xqlFileManager.setCharset(Charset.forName(properties.getCharset()));
            }
            if (StringUtils.hasLength((String)properties.getDelimiter())) {
                xqlFileManager.setDelimiter(properties.getDelimiter());
            }
            if (this.bakiProperties.getNamedParamPrefix() != ' ') {
                xqlFileManager.setNamedParamPrefix(this.bakiProperties.getNamedParamPrefix());
            }
            xqlFileManager.setCheckModified(properties.isCheckModified());
            xqlFileManager.setCheckPeriod(properties.getCheckPeriod());
            xqlFileManager.setHighlightSql(this.bakiProperties.isHighlightSql());
        }
        xqlFileManager.init();
        return xqlFileManager;
    }

    @Bean
    @ConditionalOnMissingBean
    public Baki baki() {
        SpringManagedBaki baki = new SpringManagedBaki(this.dataSource);
        baki.setDebugFullSql(this.bakiProperties.isDebugFullSql());
        baki.setCheckParameterType(this.bakiProperties.isCheckParameterType());
        baki.setStrictDynamicSqlArg(this.bakiProperties.isStrictDynamicSqlArg());
        baki.setHighlightSql(this.bakiProperties.isHighlightSql());
        baki.setXqlFileManager(this.xqlFileManager());
        if (this.bakiProperties.getNamedParamPrefix() != ' ') {
            baki.setNamedParamPrefix(baki.getNamedParamPrefix());
        }
        if (!ObjectUtils.isEmpty(this.bakiProperties.getPageHelpers())) {
            baki.setPageHelpers(this.bakiProperties.getPageHelpers());
        }
        log.info("Baki initialized (Transaction managed by Spring)");
        return baki;
    }

    @Bean
    @ConditionalOnMissingBean
    public SimpleTx simpleTx() {
        return new SimpleTx(this.transactionManager);
    }
}

