/*
 * Decompiled with CFR 0.152.
 */
package com.github.chen0040.si.utils;

import com.github.chen0040.si.utils.Interval;
import java.util.List;

public class Count {
    public static Interval quantileRange(List<Double> values, double p_lo, double p_hi) {
        int n = values.size();
        values.sort(Double::compare);
        int marked = (int)((double)n * p_lo);
        double q_lo = marked >= n ? values.get(n - 1).doubleValue() : values.get(marked).doubleValue();
        marked = (int)((double)n * p_hi);
        double q_hi = marked >= n ? values.get(n - 1).doubleValue() : values.get(marked).doubleValue();
        return new Interval(q_lo, q_hi);
    }

    public static double inverseCumulativeProbability(List<Double> values, double percentage) {
        int n = values.size();
        values.sort(Double::compare);
        int marked = (int)((double)n * percentage);
        if (marked >= n) {
            return values.get(n - 1);
        }
        return values.get(marked);
    }

    public static double cumulativeProbability(List<Double> values, double quantile) {
        int n = values.size();
        values.sort(Double::compare);
        for (int i = 0; i < n; ++i) {
            if (!(values.get(i) >= quantile)) continue;
            return ((double)i + 1.0) / (double)n;
        }
        return 1.0;
    }
}

