/*
 * Decompiled with CFR 0.152.
 */
package com.github.chen0040.si.testing;

import com.github.chen0040.si.enums.DistributionFamily;
import org.apache.commons.math3.distribution.NormalDistribution;
import org.apache.commons.math3.distribution.TDistribution;

public class TestingOnValueDifference {
    private double xHat1;
    private double xHat2;
    private double s1;
    private double s2;
    private int n1;
    private int n2;
    private double testStatistic;
    private double SE;
    private double pValueOneTail;
    private double pValueTwoTails;
    private double df;
    private DistributionFamily distributionFamily;
    private double significanceLevel = 0.001;

    public void run(double xHat1, double xHat2, double s1, double s2, int n1, int n2) {
        this.xHat1 = xHat1;
        this.xHat2 = xHat2;
        this.s1 = s1;
        this.s2 = s2;
        this.n1 = n1;
        this.n2 = n2;
        this.SE = Math.sqrt(s1 * s1 / (double)n1 + s2 * s2 / (double)n2);
        this.df = Math.min(n1 - 1, n2 - 1);
        double nullValue = 0.0;
        if (n1 < 30 || n2 < 30) {
            double t_df = (xHat1 - xHat2 - nullValue) / this.SE;
            TDistribution distribution = new TDistribution(this.df);
            double cp = distribution.cumulativeProbability(Math.abs(t_df));
            this.pValueOneTail = 1.0 - cp;
            this.pValueTwoTails = this.pValueOneTail * 2.0;
            this.testStatistic = t_df;
            this.distributionFamily = DistributionFamily.StudentT;
        } else {
            double Z = (xHat1 - xHat2 - nullValue) / this.SE;
            NormalDistribution distribution = new NormalDistribution(0.0, 1.0);
            double cp = distribution.cumulativeProbability(Math.abs(Z));
            this.pValueOneTail = 1.0 - cp;
            this.pValueTwoTails = this.pValueOneTail * 2.0;
            this.testStatistic = Z;
            this.distributionFamily = DistributionFamily.Normal;
        }
    }

    public String getSummary() {
        StringBuilder sb = new StringBuilder();
        sb.append("group 1: sample mean: ").append(this.xHat1).append(" sample sd: ").append(this.s1).append(" sample size: ").append(this.n1);
        sb.append("\ngroup 2: sample mean: ").append(this.xHat2).append(" sample sd: ").append(this.s2).append(" sample size: ").append(this.n2);
        sb.append("\nSE of sample difference distribution: ").append(this.SE);
        if (this.distributionFamily == DistributionFamily.StudentT) {
            sb.append("\ndegrees of freedom: ").append(this.df);
        }
        sb.append("\nDistribution is ").append((Object)this.distributionFamily);
        sb.append("\ntest statistic: ").append(this.testStatistic);
        sb.append("\np-value (one-tail): ").append(this.pValueOneTail);
        sb.append("\np-value (two-tail): ").append(this.pValueTwoTails);
        if (this.significanceLevel > 0.0) {
            sb.append("\nSuppose significance level is ").append(this.significanceLevel).append(", it is possible that:");
            sb.append("\n\t1) There is ").append(this.pValueOneTail < this.significanceLevel ? "not " : "").append("difference between group1 and group2").append(" under one-tail test");
            sb.append("\n\t2) There is ").append(this.pValueTwoTails < this.significanceLevel ? "not " : "").append("difference between group1 and group2").append(" under two-tails test");
        }
        return sb.toString();
    }

    public String toString() {
        return this.getSummary();
    }

    public void report() {
        System.out.println(this.toString());
    }

    public boolean willRejectH0(double significanceLevel, boolean twoTails) {
        if (twoTails) {
            return this.pValueTwoTails < significanceLevel;
        }
        return this.pValueOneTail < significanceLevel;
    }

    public double getXHat1() {
        return this.xHat1;
    }

    public double getXHat2() {
        return this.xHat2;
    }

    public double getS1() {
        return this.s1;
    }

    public double getS2() {
        return this.s2;
    }

    public int getN1() {
        return this.n1;
    }

    public int getN2() {
        return this.n2;
    }

    public double getTestStatistic() {
        return this.testStatistic;
    }

    public double getSE() {
        return this.SE;
    }

    public double getPValueOneTail() {
        return this.pValueOneTail;
    }

    public double getPValueTwoTails() {
        return this.pValueTwoTails;
    }

    public double getDf() {
        return this.df;
    }

    public DistributionFamily getDistributionFamily() {
        return this.distributionFamily;
    }

    public double getSignificanceLevel() {
        return this.significanceLevel;
    }

    public void setXHat1(double xHat1) {
        this.xHat1 = xHat1;
    }

    public void setXHat2(double xHat2) {
        this.xHat2 = xHat2;
    }

    public void setS1(double s1) {
        this.s1 = s1;
    }

    public void setS2(double s2) {
        this.s2 = s2;
    }

    public void setN1(int n1) {
        this.n1 = n1;
    }

    public void setN2(int n2) {
        this.n2 = n2;
    }

    public void setTestStatistic(double testStatistic) {
        this.testStatistic = testStatistic;
    }

    public void setSE(double SE) {
        this.SE = SE;
    }

    public void setPValueOneTail(double pValueOneTail) {
        this.pValueOneTail = pValueOneTail;
    }

    public void setPValueTwoTails(double pValueTwoTails) {
        this.pValueTwoTails = pValueTwoTails;
    }

    public void setDf(double df) {
        this.df = df;
    }

    public void setDistributionFamily(DistributionFamily distributionFamily) {
        this.distributionFamily = distributionFamily;
    }

    public void setSignificanceLevel(double significanceLevel) {
        this.significanceLevel = significanceLevel;
    }
}

