/*
 * Decompiled with CFR 0.152.
 */
package com.github.chen0040.si.testing;

import com.github.chen0040.si.enums.DistributionFamily;
import org.apache.commons.math3.distribution.NormalDistribution;
import org.apache.commons.math3.distribution.TDistribution;

public class TestingOnValue {
    private double xHat;
    private double xNull;
    private double sampleSd;
    private double standardError;
    private double df;
    private DistributionFamily distributionFamily;
    private double testStatistic;
    private double significanceLevel;
    private double pValueOneTail;
    private double pValueTwoTails;
    private int sampleSize;

    public void run(double xHat, double s, int n, double xNull) {
        this.run(xHat, s, n, xNull, 0.05);
    }

    public void run(double xHat, double s, int n, double xNull, double significanceLevel) {
        this.sampleSize = n;
        this.xHat = xHat;
        this.sampleSd = s;
        this.xNull = xNull;
        this.distributionFamily = n >= 30 ? DistributionFamily.Normal : DistributionFamily.StudentT;
        this.standardError = s / Math.sqrt(n);
        this.df = n - 1;
        this.significanceLevel = significanceLevel;
        if (this.distributionFamily == DistributionFamily.Normal) {
            NormalDistribution distribution = new NormalDistribution(0.0, 1.0);
            double Z = (xHat - xNull) / this.standardError;
            double cp = distribution.cumulativeProbability(Math.abs(Z));
            this.pValueOneTail = 1.0 - cp;
            this.pValueTwoTails = this.pValueOneTail * 2.0;
            this.testStatistic = Z;
        } else {
            TDistribution distribution = new TDistribution(this.df);
            double t_df = (xHat - xNull) / this.standardError;
            double cp = distribution.cumulativeProbability(Math.abs(t_df));
            this.pValueOneTail = 1.0 - cp;
            this.pValueTwoTails = this.pValueOneTail * 2.0;
        }
    }

    public boolean willRejectH0(double significanceLevel, boolean twoTails) {
        if (twoTails) {
            return this.pValueTwoTails < significanceLevel;
        }
        return this.pValueOneTail < significanceLevel;
    }

    public String getSummary() {
        StringBuilder sb = new StringBuilder();
        sb.append("Sample mean: ").append(this.xHat).append("Sample sd: ").append(this.sampleSd).append(" Sample size: ").append(this.sampleSize);
        sb.append("\nDistribution: ").append((Object)this.distributionFamily);
        sb.append("\np-value (one-tail): ").append(this.pValueOneTail);
        sb.append("\np-value (two-tails): ").append(this.pValueTwoTails);
        if (this.significanceLevel > 0.0) {
            sb.append("\nSuppose significance level is ").append(this.significanceLevel).append(", it is possible that:");
            sb.append("\n\t1) population mean is ").append(this.pValueOneTail < this.significanceLevel ? "not " : "").append(this.xNull).append(" under one-tail test");
            sb.append("\n\t2) population mean is ").append(this.pValueTwoTails < this.significanceLevel ? "not " : "").append(this.xNull).append(" under two-tails test");
        }
        return sb.toString();
    }

    public String toString() {
        return this.getSummary();
    }

    public void report() {
        System.out.println(this.toString());
    }

    public double getXHat() {
        return this.xHat;
    }

    public double getXNull() {
        return this.xNull;
    }

    public double getSampleSd() {
        return this.sampleSd;
    }

    public double getStandardError() {
        return this.standardError;
    }

    public double getDf() {
        return this.df;
    }

    public DistributionFamily getDistributionFamily() {
        return this.distributionFamily;
    }

    public double getTestStatistic() {
        return this.testStatistic;
    }

    public double getSignificanceLevel() {
        return this.significanceLevel;
    }

    public double getPValueOneTail() {
        return this.pValueOneTail;
    }

    public double getPValueTwoTails() {
        return this.pValueTwoTails;
    }

    public int getSampleSize() {
        return this.sampleSize;
    }

    public void setXHat(double xHat) {
        this.xHat = xHat;
    }

    public void setXNull(double xNull) {
        this.xNull = xNull;
    }

    public void setSampleSd(double sampleSd) {
        this.sampleSd = sampleSd;
    }

    public void setStandardError(double standardError) {
        this.standardError = standardError;
    }

    public void setDf(double df) {
        this.df = df;
    }

    public void setDistributionFamily(DistributionFamily distributionFamily) {
        this.distributionFamily = distributionFamily;
    }

    public void setTestStatistic(double testStatistic) {
        this.testStatistic = testStatistic;
    }

    public void setSignificanceLevel(double significanceLevel) {
        this.significanceLevel = significanceLevel;
    }

    public void setPValueOneTail(double pValueOneTail) {
        this.pValueOneTail = pValueOneTail;
    }

    public void setPValueTwoTails(double pValueTwoTails) {
        this.pValueTwoTails = pValueTwoTails;
    }

    public void setSampleSize(int sampleSize) {
        this.sampleSize = sampleSize;
    }
}

