/*
 * Decompiled with CFR 0.152.
 */
package com.github.chen0040.si.testing;

import com.github.chen0040.si.enums.DistributionFamily;
import org.apache.commons.math3.distribution.NormalDistribution;

public class TestingOnProportionDifference {
    private String successLabel;
    private double pHat1;
    private double pHat2;
    private int n1;
    private int n2;
    private double pPooled;
    private double standardError;
    private double Z;
    private double pValueOneTail;
    private double pValueTwoTails;
    private double significanceLevel = 0.001;
    private DistributionFamily distributionFamily = DistributionFamily.Normal;

    public void run(String successLabel, double pHat1, double pHat2, int sampleSize1, int sampleSize2) {
        this.successLabel = successLabel;
        this.pHat1 = pHat1;
        this.pHat2 = pHat2;
        this.n1 = sampleSize1;
        this.n2 = sampleSize2;
        int successCount1 = (int)(pHat1 * (double)sampleSize1);
        int failureCount1 = (int)((1.0 - pHat1) * (double)sampleSize1);
        int successCount2 = (int)(pHat2 * (double)sampleSize2);
        int failureCount2 = (int)((1.0 - pHat2) * (double)sampleSize2);
        if (successCount1 < 10 || successCount2 < 10 || failureCount1 < 10 || failureCount2 < 10) {
            throw new RuntimeException("Sample size too small for the testing to proceed, suggesting to use bootstrap simulation instead");
        }
        this.pPooled = (pHat1 + pHat2) / 2.0;
        this.standardError = Math.sqrt(this.pPooled * (1.0 - this.pPooled) / (double)sampleSize1 + this.pPooled * (1.0 - this.pPooled) / (double)sampleSize2);
        this.Z = (pHat1 - pHat2) / this.standardError;
        NormalDistribution distribution = new NormalDistribution(0.0, 1.0);
        double cp = distribution.cumulativeProbability(Math.abs(this.Z));
        this.pValueOneTail = 1.0 - cp;
        this.pValueTwoTails = this.pValueOneTail * 2.0;
    }

    public String getSummary() {
        StringBuilder sb = new StringBuilder();
        sb.append("group 1: sample proportion: ").append(this.pHat1).append(" sample size: ").append(this.n1);
        sb.append("\ngroup 2: sample proportion: ").append(this.pHat2).append(" sample size: ").append(this.n2);
        sb.append("\nSE of sample difference distribution: ").append(this.standardError);
        sb.append("\nDistribution is ").append((Object)this.distributionFamily);
        sb.append("\ntest statistic: ").append(this.Z);
        sb.append("\np-value (one-tail): ").append(this.pValueOneTail);
        sb.append("\np-value (two-tail): ").append(this.pValueTwoTails);
        if (this.significanceLevel > 0.0) {
            sb.append("\nSuppose significance level is ").append(this.significanceLevel).append(", it is possible that:");
            sb.append("\n\t1) There is ").append(this.pValueOneTail < this.significanceLevel ? "not " : "").append("difference for the proportion variable between group1 and group2").append(" under one-tail test");
            sb.append("\n\t2) There is ").append(this.pValueTwoTails < this.significanceLevel ? "not " : "").append("difference for the proportion variable between group1 and group2").append(" under two-tails test");
        }
        return sb.toString();
    }

    public String toString() {
        return this.getSummary();
    }

    public void report() {
        System.out.println(this.toString());
    }

    public boolean willRejectH0(double significanceLevel, boolean twoTails) {
        if (twoTails) {
            return this.pValueTwoTails < significanceLevel;
        }
        return this.pValueOneTail < significanceLevel;
    }
}

