/*
 * Decompiled with CFR 0.152.
 */
package com.github.chen0040.si.testing;

import com.github.chen0040.si.enums.DistributionFamily;
import com.github.chen0040.si.misc.Simulation;
import com.github.chen0040.si.utils.Count;
import java.util.List;
import org.apache.commons.math3.distribution.NormalDistribution;

public class TestingOnProportion {
    private double pHat;
    private double pNull;
    private int sampleSize;
    private double testStatistic;
    private double pValueOneTail;
    private double pValueTwoTails;
    private DistributionFamily distributionFamily;
    private double significanceLevel;
    private int simulationCount = 100;
    private String successLabel = "";

    public void run(String successLabel, double pHat, int sampleSize, double p) {
        this.run(successLabel, pHat, sampleSize, p, 0.05);
    }

    public void run(String successLabel, double pHat, int sampleSize, double pNull, double significanceLevel) {
        this.pHat = pHat;
        this.pNull = pNull;
        this.successLabel = successLabel;
        this.sampleSize = sampleSize;
        int successCount = (int)((double)sampleSize * pNull);
        int failureCount = (int)((double)sampleSize * (1.0 - pNull));
        if (successCount < 10 || failureCount < 10) {
            this.distributionFamily = DistributionFamily.SimulationOnly;
            List<Double> proportions = Simulation.binomial(pNull, sampleSize, this.simulationCount);
            double cp = 0.0;
            cp = pHat > 0.5 ? Count.cumulativeProbability(proportions, pHat) : 1.0 - Count.cumulativeProbability(proportions, pHat);
            this.pValueOneTail = 1.0 - cp;
            this.pValueTwoTails = this.pValueOneTail * 2.0;
        } else {
            double standardError = this.calculateStandardError(pNull, sampleSize);
            double Z = (pHat - pNull) / standardError;
            NormalDistribution distribution = new NormalDistribution(0.0, 1.0);
            double cp = distribution.cumulativeProbability(Math.abs(Z));
            this.pValueOneTail = 1.0 - cp;
            this.pValueTwoTails = this.pValueOneTail * 2.0;
            this.distributionFamily = DistributionFamily.Normal;
            this.testStatistic = Z;
        }
        this.significanceLevel = significanceLevel;
    }

    private double calculateStandardError(double p, double n) {
        return Math.sqrt(p * (1.0 - p) / n);
    }

    public boolean willRejectH0(double significanceLevel, boolean twoTails) {
        if (twoTails) {
            return this.pValueTwoTails < significanceLevel;
        }
        return this.pValueOneTail < significanceLevel;
    }

    public String getSummary() {
        StringBuilder sb = new StringBuilder();
        sb.append("Sample proportion: ").append(this.pHat).append(" Sample size: ").append(this.sampleSize);
        sb.append("\nDistribution: ").append((Object)this.distributionFamily);
        sb.append("\np-value (one-tail): ").append(this.pValueOneTail);
        sb.append("\np-value (two-tails): ").append(this.pValueTwoTails);
        if (this.significanceLevel > 0.0) {
            sb.append("\nSuppose significance level is ").append(this.significanceLevel);
            sb.append("\n\t1) population proportion of \"").append(this.successLabel).append("\" is likely ").append(this.pValueOneTail < this.significanceLevel ? "not" : "").append(" to be ").append(this.pNull).append(" under one-tail test");
            sb.append("\n\t2) population proportion is \"").append(this.successLabel).append("\" is likely ").append(this.pValueTwoTails < this.significanceLevel ? "not" : "").append(" to be ").append(this.pNull).append(" under two-tails test");
        }
        return sb.toString();
    }

    public String toString() {
        return this.getSummary();
    }

    public void report() {
        System.out.println(this.toString());
    }

    public double getPHat() {
        return this.pHat;
    }

    public double getPNull() {
        return this.pNull;
    }

    public int getSampleSize() {
        return this.sampleSize;
    }

    public double getTestStatistic() {
        return this.testStatistic;
    }

    public double getPValueOneTail() {
        return this.pValueOneTail;
    }

    public double getPValueTwoTails() {
        return this.pValueTwoTails;
    }

    public DistributionFamily getDistributionFamily() {
        return this.distributionFamily;
    }

    public double getSignificanceLevel() {
        return this.significanceLevel;
    }

    public int getSimulationCount() {
        return this.simulationCount;
    }

    public String getSuccessLabel() {
        return this.successLabel;
    }

    public void setPHat(double pHat) {
        this.pHat = pHat;
    }

    public void setPNull(double pNull) {
        this.pNull = pNull;
    }

    public void setSampleSize(int sampleSize) {
        this.sampleSize = sampleSize;
    }

    public void setTestStatistic(double testStatistic) {
        this.testStatistic = testStatistic;
    }

    public void setPValueOneTail(double pValueOneTail) {
        this.pValueOneTail = pValueOneTail;
    }

    public void setPValueTwoTails(double pValueTwoTails) {
        this.pValueTwoTails = pValueTwoTails;
    }

    public void setDistributionFamily(DistributionFamily distributionFamily) {
        this.distributionFamily = distributionFamily;
    }

    public void setSignificanceLevel(double significanceLevel) {
        this.significanceLevel = significanceLevel;
    }

    public void setSimulationCount(int simulationCount) {
        this.simulationCount = simulationCount;
    }

    public void setSuccessLabel(String successLabel) {
        this.successLabel = successLabel;
    }
}

