/*
 * Decompiled with CFR 0.152.
 */
package com.github.chen0040.si.testing;

import com.github.chen0040.si.statistics.ContingencyTable;
import java.util.List;
import org.apache.commons.math3.distribution.ChiSquaredDistribution;

public class ChiSquareTest {
    private double chiSqaure;
    private double df;
    private double pValue;
    private double significanceLevel;

    public ChiSquareTest run(ContingencyTable table) {
        return this.run(table, 1.0E-4);
    }

    public ChiSquareTest run(ContingencyTable table, double significanceLevel) {
        List<String> rows = table.rows();
        List<String> cols = table.columns();
        this.chiSqaure = 0.0;
        double total = table.total();
        for (String rowName : rows) {
            for (String colName : cols) {
                double expected = table.rowTotal(rowName) * table.columnTotal(colName) / total;
                double observed = table.get(rowName, colName);
                this.chiSqaure += Math.pow(observed - expected, 2.0) / expected;
            }
        }
        this.df = (rows.size() - 1) * (cols.size() - 1);
        ChiSquaredDistribution distribution = new ChiSquaredDistribution(this.df);
        double cp = distribution.cumulativeProbability(this.chiSqaure);
        this.pValue = 1.0 - cp;
        this.significanceLevel = significanceLevel;
        return this;
    }

    public String getSummary() {
        StringBuilder sb = new StringBuilder();
        sb.append("Chi^2: ").append(this.chiSqaure);
        sb.append("\ndegrees of freedom: ").append(this.df);
        sb.append("\np-value: ").append(this.pValue);
        if (this.significanceLevel > 0.0) {
            boolean rejectH0 = this.pValue < this.significanceLevel;
            sb.append("\nif the significance level is ").append(this.significanceLevel).append(", then ").append(rejectH0 ? "two categorical variables are dependent" : "two categorical variables are independent");
            if (rejectH0) {
                sb.append("\nIn other words, the two categorical variables are independent of each other");
            } else {
                sb.append("\nIn other words, there is a correlation between the two categorical variables");
            }
        }
        return sb.toString();
    }

    public String toString() {
        return this.getSummary();
    }

    public void report() {
        System.out.println(this.toString());
    }

    public boolean willRejectH0(double significanceLevel) {
        return this.pValue < significanceLevel;
    }

    public double getChiSqaure() {
        return this.chiSqaure;
    }

    public double getDf() {
        return this.df;
    }

    public double getPValue() {
        return this.pValue;
    }

    public double getSignificanceLevel() {
        return this.significanceLevel;
    }

    public void setChiSqaure(double chiSqaure) {
        this.chiSqaure = chiSqaure;
    }

    public void setDf(double df) {
        this.df = df;
    }

    public void setPValue(double pValue) {
        this.pValue = pValue;
    }

    public void setSignificanceLevel(double significanceLevel) {
        this.significanceLevel = significanceLevel;
    }
}

