/*
 * Decompiled with CFR 0.152.
 */
package com.github.chen0040.si.testing;

import com.github.chen0040.si.statistics.Sample;
import com.github.chen0040.si.statistics.SampleDistribution;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.math3.distribution.FDistribution;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.reflect.generics.reflectiveObjects.NotImplementedException;

public class Anova {
    private static final Logger logger = LoggerFactory.getLogger(Anova.class);
    private double sumOfSquaresTotal;
    private double grandMean;
    private double sumOfSquaresGroup;
    private double sumOfSquaresError;
    private double dfTotal;
    private double dfGroup;
    private double dfError;
    private double meanSquaresGroup;
    private double meanSquaresError;
    private double significanceLevel = 0.001;
    private double F;
    private double pValue;

    public Anova(Sample sample) {
        if (sample.isCategorical()) {
            logger.error("ANOVA can only be applied for sample that involves a numerical variable and a categorical variable");
            throw new NotImplementedException();
        }
        SampleDistribution sampleDistributionTotal = new SampleDistribution(sample, null);
        List<String> groups = sample.groups();
        HashMap<String, SampleDistribution> sampleDistributionByGroupId = new HashMap<String, SampleDistribution>();
        for (int i = 0; i < groups.size(); ++i) {
            String groupId = groups.get(i);
            SampleDistribution sampleDistributionGroup = new SampleDistribution(sample, groupId);
            sampleDistributionByGroupId.put(groupId, sampleDistributionGroup);
        }
        this.run(sampleDistributionTotal, sampleDistributionByGroupId, 0.001);
    }

    public Anova() {
    }

    public Anova run(SampleDistribution sampleDistributionTotal, Map<String, SampleDistribution> sampleDistributionByGroupId) {
        return this.run(sampleDistributionTotal, sampleDistributionByGroupId, -1.0);
    }

    public Anova run(SampleDistribution sampleDistributionTotal, Map<String, SampleDistribution> sampleDistributionByGroupId, double significanceLevel) {
        this.significanceLevel = significanceLevel;
        this.sumOfSquaresTotal = sampleDistributionTotal.getSumOfSquares();
        this.grandMean = sampleDistributionTotal.getSampleMean();
        this.sumOfSquaresGroup = 0.0;
        for (Map.Entry<String, SampleDistribution> entry : sampleDistributionByGroupId.entrySet()) {
            SampleDistribution sampleDistributionGroup = entry.getValue();
            double groupMean = sampleDistributionGroup.getSampleMean();
            this.sumOfSquaresGroup += Math.pow(groupMean - this.grandMean, 2.0) * (double)sampleDistributionGroup.getSampleSize();
        }
        this.sumOfSquaresError = this.sumOfSquaresTotal - this.sumOfSquaresGroup;
        this.dfTotal = sampleDistributionTotal.getSampleSize() - 1;
        this.dfGroup = sampleDistributionByGroupId.size() - 1;
        this.dfError = this.dfTotal - this.dfGroup;
        this.meanSquaresGroup = this.sumOfSquaresGroup / this.dfGroup;
        this.meanSquaresError = this.sumOfSquaresError / this.dfError;
        this.F = this.meanSquaresGroup / this.meanSquaresError;
        FDistribution fDistribution = new FDistribution(this.dfGroup, this.dfError);
        this.pValue = 1.0 - fDistribution.cumulativeProbability(this.F);
        return this;
    }

    public String getSummary() {
        StringBuilder sb = new StringBuilder();
        sb.append("null hypothesis: numerical variable (response) is independent of the categorical variable (explanatory)");
        sb.append("alternative hypothesis: numerical variable is correlated to the categorical variable");
        sb.append("SST (sum of squares total): ").append(this.sumOfSquaresTotal);
        sb.append("\nSSG (sum of squares group): ").append(this.sumOfSquaresGroup);
        sb.append("\nSSE (sum of squares error): ").append(this.sumOfSquaresError);
        sb.append("\ndf (total): ").append(this.dfTotal);
        sb.append("\ndf (group): ").append(this.dfGroup);
        sb.append("\ndf (error): ").append(this.dfError);
        sb.append("\nMSG (mean squares group): ").append(this.meanSquaresGroup);
        sb.append("\nMSG (mean squares error): ").append(this.meanSquaresError);
        sb.append("\nF-statistic: ").append(this.F);
        sb.append("\np-value: ").append(this.pValue);
        if (this.significanceLevel > 0.0) {
            boolean rejectH0 = this.pValue < this.significanceLevel;
            sb.append("\nIf the significance level is ").append(this.significanceLevel).append(":");
            sb.append("\n\t1) the null hypothesis is ").append(rejectH0 ? "rejected as p-value is smaller than the significance level" : "failed to be rejected");
            if (rejectH0) {
                sb.append("\n\t2) In other words, the categorical variable has no effect on the numerical variable");
            } else {
                sb.append("\n\t2) In other words, there is a correlation between the categorical variable (explanatory) numerical variable (response)");
            }
        }
        return sb.toString();
    }

    public String toString() {
        return this.getSummary();
    }

    public void report() {
        System.out.println(this.toString());
    }

    public boolean willRejectH0(double significanceLevel) {
        return this.pValue < significanceLevel;
    }

    public double getSumOfSquaresTotal() {
        return this.sumOfSquaresTotal;
    }

    public double getGrandMean() {
        return this.grandMean;
    }

    public double getSumOfSquaresGroup() {
        return this.sumOfSquaresGroup;
    }

    public double getSumOfSquaresError() {
        return this.sumOfSquaresError;
    }

    public double getDfTotal() {
        return this.dfTotal;
    }

    public double getDfGroup() {
        return this.dfGroup;
    }

    public double getDfError() {
        return this.dfError;
    }

    public double getMeanSquaresGroup() {
        return this.meanSquaresGroup;
    }

    public double getMeanSquaresError() {
        return this.meanSquaresError;
    }

    public double getSignificanceLevel() {
        return this.significanceLevel;
    }

    public double getF() {
        return this.F;
    }

    public double getPValue() {
        return this.pValue;
    }

    public void setSumOfSquaresTotal(double sumOfSquaresTotal) {
        this.sumOfSquaresTotal = sumOfSquaresTotal;
    }

    public void setGrandMean(double grandMean) {
        this.grandMean = grandMean;
    }

    public void setSumOfSquaresGroup(double sumOfSquaresGroup) {
        this.sumOfSquaresGroup = sumOfSquaresGroup;
    }

    public void setSumOfSquaresError(double sumOfSquaresError) {
        this.sumOfSquaresError = sumOfSquaresError;
    }

    public void setDfTotal(double dfTotal) {
        this.dfTotal = dfTotal;
    }

    public void setDfGroup(double dfGroup) {
        this.dfGroup = dfGroup;
    }

    public void setDfError(double dfError) {
        this.dfError = dfError;
    }

    public void setMeanSquaresGroup(double meanSquaresGroup) {
        this.meanSquaresGroup = meanSquaresGroup;
    }

    public void setMeanSquaresError(double meanSquaresError) {
        this.meanSquaresError = meanSquaresError;
    }

    public void setSignificanceLevel(double significanceLevel) {
        this.significanceLevel = significanceLevel;
    }

    public void setF(double F) {
        this.F = F;
    }

    public void setPValue(double pValue) {
        this.pValue = pValue;
    }
}

