/*
 * Decompiled with CFR 0.152.
 */
package com.github.chen0040.si.statistics;

import com.github.chen0040.si.enums.DistributionFamily;
import com.github.chen0040.si.exceptions.VariableWrongValueTypeException;
import com.github.chen0040.si.statistics.ConfidenceInterval;
import com.github.chen0040.si.statistics.SampleDistribution;
import com.github.chen0040.si.utils.Interval;
import org.apache.commons.math3.distribution.NormalDistribution;
import org.apache.commons.math3.distribution.TDistribution;
import org.apache.commons.math3.exception.OutOfRangeException;
import sun.reflect.generics.reflectiveObjects.NotImplementedException;

public class SamplingDistributionOfSampleProportionDifference {
    private final double sampleProportion1PointEstimate;
    private final double sampleProportion2PointEstimate;
    private final int sampleSize1;
    private final int sampleSize2;
    private final DistributionFamily distributionFamily;
    private final double standardError;
    private final double df;
    private final String groupId1;
    private final String groupId2;

    public SamplingDistributionOfSampleProportionDifference(SampleDistribution sampleDistribution1, SampleDistribution sampleDistribution2) {
        if (sampleDistribution1.isNumeric()) {
            throw new VariableWrongValueTypeException("Sampling distribution for sample proportions is not defined for numeric variable");
        }
        double p1 = sampleDistribution1.getProportion();
        double p2 = sampleDistribution2.getProportion();
        this.sampleProportion1PointEstimate = p1;
        this.sampleProportion2PointEstimate = p2;
        this.sampleSize1 = sampleDistribution1.getSampleSize();
        this.sampleSize2 = sampleDistribution2.getSampleSize();
        this.standardError = this.calculateStandardError(p1, p2, this.sampleSize1, this.sampleSize2);
        int successCount1 = (int)((double)this.sampleSize1 * p1);
        int failureCount1 = (int)((double)this.sampleSize1 * (1.0 - p1));
        int successCount2 = (int)((double)this.sampleSize2 * p2);
        int failureCount2 = (int)((double)this.sampleSize2 * (1.0 - p2));
        this.df = Math.min(this.sampleSize1 - 1, this.sampleSize2 - 1);
        this.distributionFamily = successCount1 < 10 || failureCount1 < 10 || successCount2 < 10 || failureCount2 < 10 ? DistributionFamily.StudentT : DistributionFamily.Normal;
        this.groupId1 = sampleDistribution1.getGroupId();
        this.groupId2 = sampleDistribution2.getGroupId();
    }

    public SamplingDistributionOfSampleProportionDifference(double p1, double p2, int sampleSize1, int sampleSize2, String groupId1, String groupId2) {
        this.sampleProportion1PointEstimate = p1;
        this.sampleProportion2PointEstimate = p2;
        this.sampleSize1 = sampleSize1;
        this.sampleSize2 = sampleSize2;
        this.df = Math.min(sampleSize1 - 1, sampleSize2 - 1);
        this.standardError = this.calculateStandardError(p1, p2, sampleSize1, sampleSize2);
        int successCount1 = (int)((double)this.sampleSize1 * p1);
        int failureCount1 = (int)((double)this.sampleSize1 * (1.0 - p1));
        int successCount2 = (int)((double)this.sampleSize2 * p2);
        int failureCount2 = (int)((double)this.sampleSize2 * (1.0 - p2));
        this.distributionFamily = successCount1 < 10 || failureCount1 < 10 || successCount2 < 10 || failureCount2 < 10 ? DistributionFamily.StudentT : DistributionFamily.Normal;
        this.groupId1 = groupId1;
        this.groupId2 = groupId2;
    }

    private double calculateStandardError(double p1, double p2, int n1, int n2) {
        return Math.sqrt(p1 * (1.0 - p1) / (double)n1 + p2 * (1.0 - p2) / (double)n2);
    }

    public double getSampleProportion1PointEstimate() {
        return this.sampleProportion1PointEstimate;
    }

    public double getSampleProportion2PointEstimate() {
        return this.sampleProportion2PointEstimate;
    }

    public double getSampleProportionDifferencePointEstimate() {
        return this.sampleProportion1PointEstimate - this.sampleProportion2PointEstimate;
    }

    public double getStandardError() {
        return this.standardError;
    }

    public int getSampleSize1() {
        return this.sampleSize1;
    }

    public ConfidenceInterval confidenceInterval(double confidenceLevel) {
        if (confidenceLevel < 0.0 || confidenceLevel > 1.0) {
            throw new OutOfRangeException((Number)confidenceLevel, (Number)0, (Number)1);
        }
        double dp_bar = this.sampleProportion1PointEstimate - this.sampleProportion2PointEstimate;
        if (this.distributionFamily == DistributionFamily.Normal) {
            NormalDistribution distribution = new NormalDistribution(0.0, 1.0);
            double p_lo = (1.0 - confidenceLevel) / 2.0;
            double p_hi = 1.0 - p_lo;
            double Z = distribution.inverseCumulativeProbability(p_hi);
            return this.makeCI(new Interval(dp_bar - Z * this.standardError, dp_bar + Z * this.standardError), confidenceLevel);
        }
        if (this.distributionFamily == DistributionFamily.StudentT) {
            TDistribution distribution = new TDistribution(this.df);
            double p_lo = (1.0 - confidenceLevel) / 2.0;
            double p_hi = 1.0 - p_lo;
            double t_df = distribution.inverseCumulativeProbability(p_hi);
            return this.makeCI(new Interval(dp_bar - t_df * this.standardError, dp_bar + t_df * this.standardError), confidenceLevel);
        }
        throw new NotImplementedException();
    }

    private ConfidenceInterval makeCI(Interval interval, double confidenceLevel) {
        StringBuilder sb = new StringBuilder();
        sb.append("We are ").append(confidenceLevel * 100.0).append("% confident that");
        sb.append(" the proportion variable in group labelled as \"").append(this.groupId1).append("\" is ");
        sb.append(interval).append(" higher than the proportion in group labelled as \"").append(this.groupId2).append("\"");
        return new ConfidenceInterval(interval, confidenceLevel, sb.toString());
    }

    public DistributionFamily getDistributionFamily() {
        return this.distributionFamily;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Proportion(").append(this.groupId1).append("-").append(this.groupId2).append(") ~ ").append((Object)this.distributionFamily).append("(mu.estimate=").append(this.sampleProportion1PointEstimate - this.sampleProportion2PointEstimate).append(", SE=").append(this.standardError).append(")");
        return sb.toString();
    }
}

