/*
 * Decompiled with CFR 0.152.
 */
package com.github.chen0040.si.statistics;

import com.github.chen0040.si.enums.DistributionFamily;
import com.github.chen0040.si.exceptions.VariableWrongValueTypeException;
import com.github.chen0040.si.misc.Simulation;
import com.github.chen0040.si.statistics.ConfidenceInterval;
import com.github.chen0040.si.statistics.SampleDistribution;
import com.github.chen0040.si.utils.Count;
import com.github.chen0040.si.utils.Interval;
import java.util.List;
import org.apache.commons.math3.distribution.NormalDistribution;
import org.apache.commons.math3.exception.OutOfRangeException;
import sun.reflect.generics.reflectiveObjects.NotImplementedException;

public class SamplingDistributionOfSampleProportion {
    private final double sampleProportionPointEstimate;
    private final int sampleSize;
    private final DistributionFamily distributionFamily;
    private final double standardError;
    private final String groupId;
    private final double df;
    private final String successLabel;
    private int simulationCount = 100;

    public SamplingDistributionOfSampleProportion(SampleDistribution sampleDistribution) {
        double p;
        if (sampleDistribution.isNumeric()) {
            throw new VariableWrongValueTypeException("Sampling distribution for sample proportions is not defined for numeric variable");
        }
        this.sampleProportionPointEstimate = p = sampleDistribution.getProportion();
        this.sampleSize = sampleDistribution.getSampleSize();
        this.successLabel = sampleDistribution.getSuccessLabel();
        this.df = this.sampleSize - 1;
        this.standardError = this.calculateStandardError(p, this.sampleSize);
        int successCount = (int)((double)this.sampleSize * p);
        int failureCount = (int)((double)this.sampleSize * (1.0 - p));
        this.distributionFamily = successCount < 10 || failureCount < 10 ? DistributionFamily.SimulationOnly : DistributionFamily.Normal;
        this.groupId = sampleDistribution.getGroupId();
    }

    public SamplingDistributionOfSampleProportion(String successLabel, double p, int sampleSize, String groupId) {
        this.successLabel = successLabel;
        this.sampleProportionPointEstimate = p;
        this.sampleSize = sampleSize;
        this.df = sampleSize - 1;
        this.standardError = this.calculateStandardError(p, sampleSize);
        int successCount = (int)((double)this.sampleSize * p);
        int failureCount = (int)((double)this.sampleSize * (1.0 - p));
        this.distributionFamily = successCount < 10 || failureCount < 10 ? DistributionFamily.StudentT : DistributionFamily.Normal;
        this.groupId = groupId;
    }

    private double calculateStandardError(double p, int sampleSize) {
        return Math.sqrt(p * (1.0 - p) / (double)sampleSize);
    }

    public double getSampleProportionPointEstimate() {
        return this.sampleProportionPointEstimate;
    }

    public double getStandardError() {
        return this.standardError;
    }

    public int getSampleSize() {
        return this.sampleSize;
    }

    public ConfidenceInterval confidenceInterval(double confidenceLevel) {
        if (confidenceLevel < 0.0 || confidenceLevel > 1.0) {
            throw new OutOfRangeException((Number)confidenceLevel, (Number)0, (Number)1);
        }
        double p_bar = this.sampleProportionPointEstimate;
        if (this.distributionFamily == DistributionFamily.Normal) {
            NormalDistribution distribution = new NormalDistribution(0.0, 1.0);
            double p_lo = (1.0 - confidenceLevel) / 2.0;
            double p_hi = 1.0 - p_lo;
            double Z = distribution.inverseCumulativeProbability(p_hi);
            return this.makeCI(new Interval(p_bar - Z * this.standardError, p_bar + Z * this.standardError), confidenceLevel);
        }
        if (this.distributionFamily == DistributionFamily.SimulationOnly) {
            List<Double> proportions = Simulation.binomial(this.sampleProportionPointEstimate, this.sampleSize, this.simulationCount);
            double p_lo = (1.0 - confidenceLevel) / 2.0;
            double p_hi = 1.0 - p_lo;
            Interval interval = Count.quantileRange(proportions, p_lo, p_hi);
            return this.makeCI(interval, confidenceLevel);
        }
        throw new NotImplementedException();
    }

    private ConfidenceInterval makeCI(Interval interval, double confidenceLevel) {
        StringBuilder sb = new StringBuilder();
        sb.append("We are ").append(confidenceLevel * 100.0).append("% confident that");
        sb.append(" the proportion of \"(").append(this.groupId).append(") is ").append(this.successLabel).append("\" is ");
        sb.append(interval);
        return new ConfidenceInterval(interval, confidenceLevel, sb.toString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("P(").append(this.groupId).append("=").append(this.successLabel).append(") ~ ").append((Object)this.distributionFamily).append("(mu.estimate=").append(this.sampleProportionPointEstimate).append(", SE=").append(this.standardError).append(")");
        return sb.toString();
    }
}

