/*
 * Decompiled with CFR 0.152.
 */
package com.github.chen0040.si.statistics;

import com.github.chen0040.si.enums.DistributionFamily;
import com.github.chen0040.si.exceptions.VariableWrongValueTypeException;
import com.github.chen0040.si.statistics.ConfidenceInterval;
import com.github.chen0040.si.statistics.SampleDistribution;
import com.github.chen0040.si.utils.Interval;
import org.apache.commons.math3.distribution.NormalDistribution;
import org.apache.commons.math3.distribution.TDistribution;
import org.apache.commons.math3.exception.OutOfRangeException;
import sun.reflect.generics.reflectiveObjects.NotImplementedException;

public class SamplingDistributionOfSampleMeanDifference {
    private final double sampleMean1PointEstimate;
    private final double sampleMean2PointEstimate;
    private final int sampleSize1;
    private final int sampleSize2;
    private final double sd1;
    private final double sd2;
    private final double standardError;
    private final double df;
    private final DistributionFamily distributionFamily;
    private final String groupId1;
    private final String groupId2;

    public SamplingDistributionOfSampleMeanDifference(SampleDistribution sampleDistribution1, SampleDistribution sampleDistribution2) {
        if (sampleDistribution1.isCategorical()) {
            throw new VariableWrongValueTypeException("Sampling distribution of sample means are not defined for categorical variable");
        }
        this.sampleMean1PointEstimate = sampleDistribution1.getSampleMean();
        this.sampleMean2PointEstimate = sampleDistribution2.getSampleMean();
        this.sd1 = sampleDistribution1.getSampleSd();
        this.sd2 = sampleDistribution2.getSampleSd();
        this.sampleSize1 = sampleDistribution1.getSampleSize();
        this.sampleSize2 = sampleDistribution2.getSampleSize();
        this.standardError = this.calculateStandardError(this.sd1, this.sd2, this.sampleSize1, this.sampleSize2);
        this.df = Math.min(this.sampleSize1 - 1, this.sampleSize2 - 1);
        this.distributionFamily = this.sampleSize1 < 30 || this.sampleSize2 < 30 ? DistributionFamily.StudentT : DistributionFamily.Normal;
        this.groupId1 = sampleDistribution1.getGroupId();
        this.groupId2 = sampleDistribution2.getGroupId();
    }

    public SamplingDistributionOfSampleMeanDifference(double sampleMean1PointEstimate, double sampleMean2PointEstimate, double sd1, double sd2, int sampleSize1, int sampleSize2, String groupId1, String groupId2) {
        this.sampleMean1PointEstimate = sampleMean1PointEstimate;
        this.sampleMean2PointEstimate = sampleMean2PointEstimate;
        this.sampleSize1 = sampleSize1;
        this.sampleSize2 = sampleSize2;
        this.sd1 = sd1;
        this.sd2 = sd2;
        this.standardError = this.calculateStandardError(this.sd1, this.sd2, this.sampleSize1, this.sampleSize2);
        this.df = Math.min(this.sampleSize1 - 1, this.sampleSize2 - 1);
        this.distributionFamily = this.sampleSize1 < 30 || this.sampleSize2 < 30 ? DistributionFamily.StudentT : DistributionFamily.Normal;
        this.groupId1 = groupId1;
        this.groupId2 = groupId2;
    }

    private double calculateStandardError(double sd1, double sd2, int sampleSize1, int sampleSize2) {
        return Math.sqrt(sd1 * sd1 / (double)sampleSize1 + sd2 * sd2 / (double)sampleSize2);
    }

    public double getSampleMean1PointEstimate() {
        return this.sampleMean1PointEstimate;
    }

    public double getSampleMean2PointEstimate() {
        return this.sampleMean2PointEstimate;
    }

    public double getSampleMeanDifferencePointEstimate() {
        return this.sampleMean1PointEstimate - this.sampleMean2PointEstimate;
    }

    public double getStandardError() {
        return this.standardError;
    }

    public int getSampleSize1() {
        return this.sampleSize1;
    }

    public int getSampleSize2() {
        return this.sampleSize2;
    }

    public ConfidenceInterval confidenceInterval(double confidenceLevel) {
        if (confidenceLevel < 0.0 || confidenceLevel > 1.0) {
            throw new OutOfRangeException((Number)confidenceLevel, (Number)0, (Number)1);
        }
        double dx_bar = this.sampleMean1PointEstimate - this.sampleMean2PointEstimate;
        if (this.distributionFamily == DistributionFamily.Normal) {
            NormalDistribution distribution = new NormalDistribution(0.0, 1.0);
            double p_lo = (1.0 - confidenceLevel) / 2.0;
            double p_hi = 1.0 - p_lo;
            double Z = distribution.inverseCumulativeProbability(p_hi);
            return this.makeCI(new Interval(dx_bar - Z * this.standardError, dx_bar + Z * this.standardError), confidenceLevel);
        }
        if (this.distributionFamily == DistributionFamily.StudentT) {
            TDistribution distribution = new TDistribution(this.df);
            double p_lo = (1.0 - confidenceLevel) / 2.0;
            double p_hi = 1.0 - p_lo;
            double t_df = distribution.inverseCumulativeProbability(p_hi);
            return this.makeCI(new Interval(dx_bar - t_df * this.standardError, dx_bar + t_df * this.standardError), confidenceLevel);
        }
        throw new NotImplementedException();
    }

    private ConfidenceInterval makeCI(Interval interval, double confidenceLevel) {
        StringBuilder sb = new StringBuilder();
        sb.append("We are ").append(confidenceLevel * 100.0).append("% confident that");
        sb.append(" the value of \"").append(this.groupId1).append("\" is ");
        sb.append(interval).append(" higher than the value of \"").append(this.groupId2).append("\"");
        return new ConfidenceInterval(interval, confidenceLevel, sb.toString());
    }

    public DistributionFamily getDistributionFamily() {
        return this.distributionFamily;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.groupId1).append("-").append(this.groupId2).append(" ~ ").append((Object)this.distributionFamily).append("(mu.estimate=").append(this.sampleMean1PointEstimate - this.sampleMean2PointEstimate).append(", SE=").append(this.standardError).append(")");
        return sb.toString();
    }
}

