/*
 * Decompiled with CFR 0.152.
 */
package com.github.chen0040.si.statistics;

import com.github.chen0040.si.enums.DistributionFamily;
import com.github.chen0040.si.exceptions.VariableWrongValueTypeException;
import com.github.chen0040.si.statistics.ConfidenceInterval;
import com.github.chen0040.si.statistics.SampleDistribution;
import com.github.chen0040.si.utils.Interval;
import org.apache.commons.math3.distribution.NormalDistribution;
import org.apache.commons.math3.distribution.TDistribution;
import org.apache.commons.math3.exception.OutOfRangeException;
import sun.reflect.generics.reflectiveObjects.NotImplementedException;

public class SamplingDistributionOfSampleMean {
    private final double sampleMeanPointEstimate;
    private final int sampleSize;
    private final double sd;
    private final double standardError;
    private final double df;
    private final DistributionFamily distributionFamily;
    private final String groupId;

    public SamplingDistributionOfSampleMean(SampleDistribution sampleDistribution) {
        if (sampleDistribution.isCategorical()) {
            throw new VariableWrongValueTypeException("Sampling distribution of sample means are not defined for categorical variable");
        }
        this.sampleMeanPointEstimate = sampleDistribution.getSampleMean();
        this.sd = sampleDistribution.getSampleSd();
        this.sampleSize = sampleDistribution.getSampleSize();
        this.standardError = this.calculateStandardError(this.sd, this.sampleSize);
        this.df = this.sampleSize - 1;
        this.distributionFamily = this.sampleSize < 30 ? DistributionFamily.StudentT : DistributionFamily.Normal;
        this.groupId = sampleDistribution.getGroupId();
    }

    public SamplingDistributionOfSampleMean(double sampleMeanPointEstimate, int sampleSize, double sd, String groupId) {
        this.sampleMeanPointEstimate = sampleMeanPointEstimate;
        this.sampleSize = sampleSize;
        this.sd = sd;
        this.standardError = this.calculateStandardError(sd, sampleSize);
        this.df = sampleSize - 1;
        this.distributionFamily = sampleSize < 30 ? DistributionFamily.StudentT : DistributionFamily.Normal;
        this.groupId = groupId;
    }

    private double calculateStandardError(double sd, int sampleSize) {
        return sd / Math.sqrt(sampleSize);
    }

    public double getSampleMeanPointEstimate() {
        return this.sampleMeanPointEstimate;
    }

    public double getStandardError() {
        return this.standardError;
    }

    public int getSampleSize() {
        return this.sampleSize;
    }

    public ConfidenceInterval confidenceInterval(double confidenceLevel) {
        if (confidenceLevel < 0.0 || confidenceLevel > 1.0) {
            throw new OutOfRangeException((Number)confidenceLevel, (Number)0, (Number)1);
        }
        double x_bar = this.sampleMeanPointEstimate;
        if (this.distributionFamily == DistributionFamily.Normal) {
            NormalDistribution distribution = new NormalDistribution(0.0, 1.0);
            double p_lo = (1.0 - confidenceLevel) / 2.0;
            double p_hi = 1.0 - p_lo;
            double Z = distribution.inverseCumulativeProbability(p_hi);
            return this.makeCI(new Interval(x_bar - Z * this.standardError, x_bar + Z * this.standardError), confidenceLevel);
        }
        if (this.distributionFamily == DistributionFamily.StudentT) {
            TDistribution distribution = new TDistribution(this.df);
            double p_lo = (1.0 - confidenceLevel) / 2.0;
            double p_hi = 1.0 - p_lo;
            double t_df = distribution.inverseCumulativeProbability(p_hi);
            return this.makeCI(new Interval(x_bar - t_df * this.standardError, x_bar + t_df * this.standardError), confidenceLevel);
        }
        throw new NotImplementedException();
    }

    private ConfidenceInterval makeCI(Interval interval, double confidenceLevel) {
        StringBuilder sb = new StringBuilder();
        sb.append("We are ").append(confidenceLevel * 100.0).append("% confident that");
        sb.append(" the mean of \"").append(this.groupId).append("\" is ");
        sb.append(interval);
        return new ConfidenceInterval(interval, confidenceLevel, sb.toString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.groupId).append(" ~ ").append((Object)this.distributionFamily).append("(mu.estimate=").append(this.sampleMeanPointEstimate).append(", SE=").append(this.standardError).append(")");
        return sb.toString();
    }
}

