/*
 * Decompiled with CFR 0.152.
 */
package com.github.chen0040.si.statistics;

import com.github.chen0040.si.exceptions.VariableWrongValueTypeException;
import com.github.chen0040.si.statistics.Observation;
import com.github.chen0040.si.statistics.Sample;
import com.github.chen0040.si.utils.TupleTwo;

public class SampleLinearRegression {
    private double xBar;
    private double yBar;
    private double sX;
    private double sY;
    private double correlation;
    private double R2;
    private double slope;
    private double intercept;

    public SampleLinearRegression(Sample sample) {
        int sampleSize = sample.countByGroupId(null);
        if (!sample.containsTwoNumericalVariables()) {
            throw new VariableWrongValueTypeException("Sample 1 should contain numeric variable x and y");
        }
        TupleTwo tuple = sample.getObservations().stream().map(o -> new TupleTwo<Double, Double>(o.getX(), o.getY())).reduce((a, b) -> new TupleTwo<Double, Double>((Double)a._1() + (Double)b._1(), (Double)a._2() + (Double)b._2())).get();
        this.xBar = (Double)tuple._1() / (double)sampleSize;
        this.yBar = (Double)tuple._2() / (double)sampleSize;
        double sum = 0.0;
        double sum_x = 0.0;
        double sum_y = 0.0;
        for (int i = 0; i < sampleSize; ++i) {
            Observation o2 = sample.get(i);
            double x = o2.getX();
            double y = o2.getY();
            double x_d = x - this.xBar;
            double y_d = y - this.yBar;
            sum += x_d * y_d;
            sum_x += x_d * x_d;
            sum_y += y_d * y_d;
        }
        this.sX = sum_x / (double)(sampleSize - 1);
        this.sY = sum_y / (double)(sampleSize - 1);
        this.correlation = sum / (Math.sqrt(sum_x) * Math.sqrt(sum_y));
        this.R2 = this.correlation * this.correlation;
        this.slope = this.calculateSlope(this.sX, this.sY, this.correlation);
        this.intercept = this.calculateIntercept(this.xBar, this.yBar, this.slope);
    }

    private double calculateSlope(double sd_x, double sd_y, double correlation) {
        return sd_y * correlation / sd_x;
    }

    private double calculateIntercept(double x_bar, double y_bar, double slope) {
        return y_bar - x_bar * slope;
    }

    public double getXBar() {
        return this.xBar;
    }

    public double getYBar() {
        return this.yBar;
    }

    public double getSX() {
        return this.sX;
    }

    public double getSY() {
        return this.sY;
    }

    public double getCorrelation() {
        return this.correlation;
    }

    public double getR2() {
        return this.R2;
    }

    public double getSlope() {
        return this.slope;
    }

    public double getIntercept() {
        return this.intercept;
    }

    public void setXBar(double xBar) {
        this.xBar = xBar;
    }

    public void setYBar(double yBar) {
        this.yBar = yBar;
    }

    public void setSX(double sX) {
        this.sX = sX;
    }

    public void setSY(double sY) {
        this.sY = sY;
    }

    public void setCorrelation(double correlation) {
        this.correlation = correlation;
    }

    public void setR2(double R2) {
        this.R2 = R2;
    }

    public void setSlope(double slope) {
        this.slope = slope;
    }

    public void setIntercept(double intercept) {
        this.intercept = intercept;
    }
}

