/*
 * Decompiled with CFR 0.152.
 */
package com.github.chen0040.si.statistics;

import com.github.chen0040.si.exceptions.VariableWrongValueTypeException;
import com.github.chen0040.si.statistics.Observation;
import com.github.chen0040.si.statistics.Sample;
import sun.reflect.generics.reflectiveObjects.NotImplementedException;

public class SampleDistribution {
    private double sampleMean;
    private double sampleSd;
    private double sampleVariance;
    private boolean isNumeric;
    private int sampleSize;
    private double proportion;
    private String successLabel;
    private final String groupId;
    private double sumOfSquares;

    public SampleDistribution(Sample sample, String groupId) {
        if (!sample.isNumeric()) {
            throw new VariableWrongValueTypeException("The constructor can only work on numeric variables");
        }
        this.groupId = groupId;
        this.isNumeric = true;
        this.sampleMean = sample.getObservations().stream().filter(o -> groupId == null || groupId.equals(o.getGroupId())).map(Observation::getX).reduce((a, b) -> a + b).get() / (double)sample.countByGroupId(groupId);
        this.sumOfSquares = sample.getObservations().stream().filter(o -> groupId == null || groupId.equals(o.getGroupId())).map(o -> Math.pow(o.getX() - this.sampleMean, 2.0)).reduce((a, b) -> a + b).get();
        this.sampleVariance = this.sumOfSquares / (double)(sample.countByGroupId(groupId) - 1);
        this.sampleSd = Math.sqrt(this.sampleVariance);
        this.sampleSize = sample.countByGroupId(groupId);
    }

    public SampleDistribution(Sample sample, String successLabel, String groupId) {
        if (sample.isNumeric()) {
            throw new VariableWrongValueTypeException("The constructor can only work on categorical variables");
        }
        this.groupId = groupId;
        this.isNumeric = false;
        this.sampleMean = (double)sample.countByGroupId(groupId) * sample.proportion(successLabel, groupId);
        this.proportion = sample.proportion(successLabel, groupId);
        this.sampleVariance = (double)sample.countByGroupId(groupId) * this.proportion * (1.0 - this.proportion);
        this.sampleSd = Math.sqrt(this.sampleVariance);
        this.sampleSize = sample.countByGroupId(groupId);
        this.successLabel = successLabel;
    }

    public SampleDistribution(double sampleMean, int sampleSize, double sampleSd, String groupId) {
        this.sampleMean = sampleMean;
        this.sampleSize = sampleSize;
        this.sampleSd = sampleSd;
        this.sampleVariance = sampleSd * sampleSd;
        this.sumOfSquares = this.sampleVariance * (double)(sampleSize - 1);
        this.isNumeric = true;
        this.groupId = groupId;
    }

    public SampleDistribution(String successLabel, double sampleProportion, int sampleSize, String groupId) {
        this.proportion = this.sampleMean;
        this.successLabel = successLabel;
        this.sampleSize = sampleSize;
        this.sampleVariance = (double)sampleSize * (1.0 - this.proportion) * this.proportion;
        this.sampleMean = this.proportion * (double)sampleSize;
        this.sampleSd = Math.sqrt(this.sampleVariance);
        this.sumOfSquares = this.sampleVariance * (double)(sampleSize - 1);
        this.isNumeric = false;
        this.groupId = groupId;
    }

    public double getProportion() {
        if (this.isNumeric()) {
            throw new NotImplementedException();
        }
        return this.proportion;
    }

    public void setProportion(double p) {
        this.proportion = p;
    }

    public String getSuccessLabel() {
        if (this.isNumeric()) {
            throw new NotImplementedException();
        }
        return this.successLabel;
    }

    public void setSuccessLabel(String successLabel) {
        this.successLabel = successLabel;
    }

    public boolean isCategorical() {
        return !this.isNumeric();
    }

    public double getSumOfSquares() {
        if (!this.isNumeric()) {
            throw new NotImplementedException();
        }
        return this.sumOfSquares;
    }

    public double getSampleMean() {
        return this.sampleMean;
    }

    public double getSampleSd() {
        return this.sampleSd;
    }

    public double getSampleVariance() {
        return this.sampleVariance;
    }

    public boolean isNumeric() {
        return this.isNumeric;
    }

    public int getSampleSize() {
        return this.sampleSize;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setSampleMean(double sampleMean) {
        this.sampleMean = sampleMean;
    }

    public void setSampleSd(double sampleSd) {
        this.sampleSd = sampleSd;
    }

    public void setSampleVariance(double sampleVariance) {
        this.sampleVariance = sampleVariance;
    }

    public void setNumeric(boolean isNumeric) {
        this.isNumeric = isNumeric;
    }

    public void setSampleSize(int sampleSize) {
        this.sampleSize = sampleSize;
    }
}

