/*
 * Decompiled with CFR 0.152.
 */
package com.github.chen0040.si.statistics;

import com.github.chen0040.si.exceptions.NoObservationFoundException;
import com.github.chen0040.si.exceptions.VariableMixedValueTypeException;
import com.github.chen0040.si.exceptions.VariableWrongValueTypeException;
import com.github.chen0040.si.statistics.Observation;
import com.github.chen0040.si.statistics.SampleMetaData;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class Sample {
    private final List<Observation> observations = new ArrayList<Observation>();
    private Optional<Boolean> isNumeric = Optional.empty();
    private final Set<String> groups = new HashSet<String>();
    private SampleMetaData metaData = new SampleMetaData();

    public void add(Observation observation) {
        if (this.isNumeric.isPresent()) {
            boolean numericOnly = this.isNumeric.get();
            if (observation.isNumeric() != numericOnly) {
                throw new VariableMixedValueTypeException("sample should only contain ".concat(numericOnly ? "numeric" : "categorical").concat(" values"));
            }
        } else {
            this.isNumeric = Optional.of(observation.isNumeric());
        }
        this.groups.add(observation.getGroupId());
        this.observations.add(observation);
    }

    public boolean isNumeric() {
        if (!this.isNumeric.isPresent()) {
            throw new NoObservationFoundException("No observation is found in the sample");
        }
        return this.isNumeric.get();
    }

    public boolean isCategorical() {
        return !this.isNumeric();
    }

    public int countByGroupId(String groupId) {
        return (int)this.observations.stream().filter(o -> groupId == null || groupId.equals(o.getGroupId())).count();
    }

    public Observation get(int index) {
        return this.observations.get(index);
    }

    public double proportion(String successLabel, String groupId) {
        if (this.isNumeric()) {
            throw new VariableWrongValueTypeException("proportional can only be calculated on categorical variables");
        }
        return (double)this.observations.stream().filter(o -> groupId == null || groupId.equals(o.getGroupId())).filter(o -> o.getCategoricalValue().equals(successLabel)).count() / (double)this.countByGroupId(groupId);
    }

    public List<Observation> getObservations() {
        return this.observations;
    }

    public List<String> groups() {
        return this.groups.stream().collect(Collectors.toList());
    }

    public SampleMetaData metaData() {
        return this.metaData;
    }

    public boolean containsTwoNumericalVariables() {
        return this.observations.get(0).containsTwoNumericalVariables();
    }
}

