/*
 * Decompiled with CFR 0.152.
 */
package com.github.chen0040.si.statistics;

import java.io.Serializable;
import java.util.Optional;

public class Observation
implements Serializable {
    private Optional<Double> x = Optional.empty();
    private Optional<Double> y = Optional.empty();
    private Optional<String> categoricalValue = Optional.empty();
    private String groupId = "";

    public void setCategory(String category) {
        if (this.isNumeric()) {
            throw new RuntimeException("Observation is already marked as numeric");
        }
        this.categoricalValue = Optional.of(category);
    }

    public void setX(double numeric) {
        if (this.isCategorical()) {
            throw new RuntimeException("Observation is already marked as categorical");
        }
        this.x = Optional.of(numeric);
    }

    public void setY(double numeric) {
        if (this.isCategorical()) {
            throw new RuntimeException("Observation is already marked as categorical");
        }
        this.y = Optional.of(numeric);
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public boolean isNumeric() {
        return this.x.isPresent();
    }

    public boolean isCategorical() {
        return this.categoricalValue.isPresent();
    }

    public double getX() {
        return this.x.get();
    }

    public double getY() {
        return this.y.get();
    }

    public String getCategoricalValue() {
        return this.categoricalValue.get();
    }

    public boolean containsTwoNumericalVariables() {
        return this.x.isPresent() && this.y.isPresent();
    }
}

