/*
 * Decompiled with CFR 0.152.
 */
package com.github.chen0040.si.statistics;

import com.github.chen0040.si.statistics.Observation;
import com.github.chen0040.si.statistics.Sample;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class ContingencyTable {
    private Set<String> rowNames = new HashSet<String>();
    private Set<String> colNames = new HashSet<String>();
    private Map<String, Double> cells = new HashMap<String, Double>();

    public ContingencyTable() {
    }

    public ContingencyTable(Sample sample) {
        int count = sample.countByGroupId(null);
        for (int i = 0; i < count; ++i) {
            Observation observation = sample.get(i);
            String value1 = observation.getCategoricalValue();
            String value2 = observation.getGroupId();
            this.put(value1, value2, this.get(value1, value2) + 1.0);
        }
    }

    public void put(String rowName, String colName, double value) {
        this.rowNames.add(rowName);
        this.colNames.add(colName);
        this.cells.put(this.key(rowName, colName), value);
    }

    public double get(String rowName, String colName) {
        return this.cells.getOrDefault(this.key(rowName, colName), 0.0);
    }

    private String key(String rowName, String colName) {
        return rowName.concat("-").concat(colName);
    }

    public List<String> rows() {
        return this.rowNames.stream().collect(Collectors.toList());
    }

    public List<String> columns() {
        return this.colNames.stream().collect(Collectors.toList());
    }

    public double rowTotal(String rowName) {
        double sum = 0.0;
        for (String colName : this.colNames) {
            sum += this.get(rowName, colName);
        }
        return sum;
    }

    public double columnTotal(String colName) {
        double sum = 0.0;
        for (String rowName : this.rowNames) {
            sum += this.get(rowName, colName);
        }
        return sum;
    }

    public double total() {
        double sum = 0.0;
        for (Double val : this.cells.values()) {
            sum += val.doubleValue();
        }
        return sum;
    }

    public String getSummary() {
        StringBuilder sb = new StringBuilder();
        for (String rowName : this.rowNames) {
            for (String colName : this.colNames) {
                double value = this.get(rowName, colName);
                sb.append("Cell.Count[").append(rowName).append("][").append(colName).append("]: ").append(value).append("\n");
            }
        }
        for (String rowName : this.rowNames) {
            sb.append("Row.Count[").append(rowName).append("]: ").append(this.rowTotal(rowName)).append("\n");
        }
        for (String colName : this.colNames) {
            sb.append("Col.Count[").append(colName).append("]: ").append(this.columnTotal(colName)).append("\n");
        }
        return sb.toString();
    }
}

