/*
 * Decompiled with CFR 0.152.
 */
package com.github.chen0040.si.statistics;

import com.github.chen0040.si.exceptions.VariableWrongValueTypeException;
import com.github.chen0040.si.statistics.Sample;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CentralLimitTheorem {
    private static Logger logger = LoggerFactory.getLogger(CentralLimitTheorem.class);

    public static boolean isHeld4SampleProportion(Sample sample, String successLabel, String groupId) {
        if (sample.isNumeric()) {
            logger.warn("0 (failed): only CTL for proportion works for categorical variable");
            throw new VariableWrongValueTypeException("Only CTL for proportion works for categorical variable");
        }
        logger.info("0 (success): sample contains categorical variable");
        if (!sample.metaData().isRandomlySampledOrAssigned()) {
            logger.warn("0 (failed): observations in the sample must be randomly sampled or assigned");
            return false;
        }
        logger.info("0 (success): randomly sampled or assigned");
        int n = sample.countByGroupId(groupId);
        if (!sample.metaData().isSampledWithReplacement()) {
            if (n >= sample.metaData().getTruePopulationSize() * 10 / 100) {
                logger.warn("if sampled without replacement, then the sample size must be smaller than 10% of the true population under study");
                return false;
            }
            logger.info("1 (success): sampling without replacement, the sample size is smaller than 10% of the population size");
        } else {
            logger.info("1 (success): sampling with replacement");
        }
        double p = sample.proportion(successLabel, groupId);
        int successCount = (int)(p * (double)n);
        int failureCount = (int)((1.0 - p) * (double)n);
        if (successCount >= 10 && failureCount >= 10) {
            logger.info("2 (success): success and failures both greater than or equal to 10");
            return true;
        }
        logger.warn("2 (failed): success or failures smaller than 10");
        return false;
    }

    public static boolean isHeld4SampleMean(Sample sample, String groupId) {
        if (!sample.isNumeric()) {
            logger.error("0 (failed): only CTL for proportion works for categorical variable");
            throw new VariableWrongValueTypeException("Only CTL for proportion works for categorical variable");
        }
        logger.info("0 (success): numerical variable is present in the sample");
        if (!sample.metaData().isRandomlySampledOrAssigned()) {
            logger.warn("1 (failed): observations in the sample must be randomly sampled or assigned");
            return false;
        }
        logger.info("1 (success): sample is randomly sampled or assigned");
        int n = sample.countByGroupId(groupId);
        if (!sample.metaData().isSampledWithReplacement()) {
            if (n >= sample.metaData().getTruePopulationSize() * 10 / 100) {
                logger.warn("1 (failed): if sampled without replacement, then the sample size must be smaller than 10% of the true population under study");
                return false;
            }
            logger.info("1 (success): sampling without replacement, with sample size smaller than 10% of the population size");
        } else {
            logger.info("1 (success): sampling with replacement");
        }
        if (sample.countByGroupId(groupId) >= 30) {
            logger.info("2 (success): sample size > 30");
            return true;
        }
        logger.warn("2 (failed): sample must be greater or equal to 30 for CLT");
        return false;
    }
}

