/*
 * Decompiled with CFR 0.152.
 */
package com.github.chen0040.si.dsl;

import com.github.chen0040.data.frame.DataFrame;
import com.github.chen0040.data.frame.DataRow;
import com.github.chen0040.si.dsl.MeanDifference;
import com.github.chen0040.si.dsl.Variable;
import com.github.chen0040.si.statistics.Observation;
import com.github.chen0040.si.statistics.Sample;
import com.github.chen0040.si.statistics.SampleDistribution;
import com.github.chen0040.si.statistics.SamplingDistributionOfSampleMeanDifference;
import com.github.chen0040.si.testing.TestingOnValueDifference;

public class TwoGroupNumericalSampleKie {
    private final Variable variable;
    private final Variable groupVariable;
    private Sample sample = new Sample();
    private final String group1Id;
    private final String group2Id;
    private double sample1Mean;
    private double sample1Sd;
    private int sample1Size;
    private double sample2Mean;
    private double sample2Sd;
    private int sample2Size;
    private SampleDistribution sample1Distribution = null;
    private SampleDistribution sample2Distribution = null;
    private SamplingDistributionOfSampleMeanDifference samplingDistributionOfSampleMeanDifference = null;

    public TwoGroupNumericalSampleKie(Variable variable, Variable groupVariable, String group1Id, String group2Id) {
        this.variable = variable;
        this.groupVariable = groupVariable;
        this.group1Id = group1Id;
        this.group2Id = group2Id;
    }

    public TwoGroupNumericalSampleKie fromSampleDistributions(double sample1Mean, double sample2Mean, double sample1Sd, double sample2Sd, int sample1Size, int sample2Size) {
        this.sample = null;
        this.sample1Mean = sample1Mean;
        this.sample1Size = sample1Size;
        this.sample1Sd = sample1Sd;
        this.sample2Mean = sample2Mean;
        this.sample2Size = sample2Size;
        this.sample2Sd = sample2Sd;
        this.sample1Distribution = new SampleDistribution(sample1Mean, sample1Size, sample1Sd, this.group1Id);
        this.sample2Distribution = new SampleDistribution(sample2Mean, sample2Size, sample2Sd, this.group2Id);
        this.samplingDistributionOfSampleMeanDifference = new SamplingDistributionOfSampleMeanDifference(sample1Mean, sample2Mean, sample1Sd, sample2Sd, sample1Size, sample2Size, this.group1Id, this.group2Id);
        return this;
    }

    public TwoGroupNumericalSampleKie addObservation(double value, String groupId) {
        if (this.sample == null) {
            throw new RuntimeException("distribution is already provided, cannot add observation");
        }
        Observation observation = new Observation();
        observation.setX(value);
        observation.setGroupId(groupId);
        this.sample.add(observation);
        if (groupId.equals(this.group1Id)) {
            this.sample1Distribution = null;
        }
        if (groupId.equals(this.group2Id)) {
            this.sample2Distribution = null;
        }
        this.samplingDistributionOfSampleMeanDifference = null;
        return this;
    }

    private SampleDistribution getGroup1SampleDistribution() {
        if (this.sample1Distribution == null) {
            this.sample1Distribution = new SampleDistribution(this.sample, this.group1Id);
        }
        return this.sample1Distribution;
    }

    private SampleDistribution getGroup2SampleDistribution() {
        if (this.sample2Distribution == null) {
            this.sample2Distribution = new SampleDistribution(this.sample, this.group2Id);
        }
        return this.sample2Distribution;
    }

    public SamplingDistributionOfSampleMeanDifference getSamplingDistribution() {
        if (this.samplingDistributionOfSampleMeanDifference == null) {
            this.samplingDistributionOfSampleMeanDifference = new SamplingDistributionOfSampleMeanDifference(this.getGroup1SampleDistribution(), this.getGroup2SampleDistribution());
        }
        return this.samplingDistributionOfSampleMeanDifference;
    }

    public MeanDifference difference() {
        return new MeanDifference(this.getSamplingDistribution());
    }

    private String group1Id() {
        return this.group1Id;
    }

    private String group2Id() {
        return this.group2Id;
    }

    public TestingOnValueDifference test4GroupDifference() {
        if (this.sample != null) {
            TestingOnValueDifference test = new TestingOnValueDifference();
            SampleDistribution distribution1 = this.getGroup1SampleDistribution();
            SampleDistribution distribution2 = this.getGroup2SampleDistribution();
            double xHat1 = distribution1.getSampleMean();
            double sd1 = distribution1.getSampleSd();
            int n1 = distribution1.getSampleSize();
            double xHat2 = distribution2.getSampleMean();
            double sd2 = distribution2.getSampleSd();
            int n2 = distribution2.getSampleSize();
            test.run(xHat1, xHat2, sd1, sd2, n1, n2);
            return test;
        }
        TestingOnValueDifference test = new TestingOnValueDifference();
        test.run(this.sample1Mean, this.sample2Mean, this.sample1Sd, this.sample2Sd, this.sample1Size, this.sample2Size);
        return test;
    }

    public void addObservations(DataFrame dataFrame) {
        for (int i = 0; i < dataFrame.rowCount(); ++i) {
            DataRow row = dataFrame.row(i);
            String groupId = row.getCategoricalCell(this.groupVariable.getName());
            if (!groupId.equals(this.group1Id) && !groupId.equals(this.group2Id)) continue;
            double value = row.getCell(this.variable.getName());
            this.addObservation(value, groupId);
        }
    }

    public double getGroup1SampleMean() {
        return this.getGroup1SampleDistribution().getSampleMean();
    }

    public double getGroup1SampleSd() {
        return this.getGroup1SampleDistribution().getSampleSd();
    }

    public double getGroup1SampleSize() {
        return this.getGroup1SampleDistribution().getSampleSize();
    }

    public double getGroup2SampleMean() {
        return this.getGroup2SampleDistribution().getSampleMean();
    }

    public double getGroup2SampleSd() {
        return this.getGroup2SampleDistribution().getSampleSd();
    }

    public double getGroup2SampleSize() {
        return this.getGroup2SampleDistribution().getSampleSize();
    }
}

