/*
 * Decompiled with CFR 0.152.
 */
package com.github.chen0040.si.dsl;

import com.github.chen0040.data.frame.DataFrame;
import com.github.chen0040.data.frame.DataRow;
import com.github.chen0040.si.dsl.Proportion;
import com.github.chen0040.si.dsl.ProportionDifference;
import com.github.chen0040.si.dsl.Variable;
import com.github.chen0040.si.statistics.Observation;
import com.github.chen0040.si.statistics.Sample;
import com.github.chen0040.si.statistics.SampleDistribution;
import com.github.chen0040.si.statistics.SamplingDistributionOfSampleProportion;
import com.github.chen0040.si.statistics.SamplingDistributionOfSampleProportionDifference;
import com.github.chen0040.si.testing.TestingOnProportionDifference;
import java.util.HashMap;
import java.util.Map;

public class TwoGroupCategoricalSampleKie {
    private final Variable variable;
    private final Variable groupVariable;
    private final String group1Id;
    private final String group2Id;
    private Sample sample;
    private double sample1Proportion;
    private int sample1Size;
    private double sample2Proportion;
    private int sample2Size;
    private String successLabel;
    private Map<String, SampleDistribution> sample1DistributionMap = new HashMap<String, SampleDistribution>();
    private Map<String, SampleDistribution> sample2DistributionMap = new HashMap<String, SampleDistribution>();

    public TwoGroupCategoricalSampleKie(Variable variable, Variable groupVariable, String group1Id, String group2Id) {
        this.variable = variable;
        this.groupVariable = groupVariable;
        this.sample = new Sample();
        this.successLabel = null;
        this.group1Id = group1Id;
        this.group2Id = group2Id;
    }

    public TwoGroupCategoricalSampleKie fromSampleDistributions(String successLabel, double sample1Proportion, double sample2Proportion, int sample1Size, int sample2Size) {
        this.sample1Proportion = sample1Proportion;
        this.sample2Proportion = sample2Proportion;
        this.sample1Size = sample1Size;
        this.sample2Size = sample2Size;
        this.successLabel = successLabel;
        return this;
    }

    public TwoGroupCategoricalSampleKie addObservation(String value, String groupId) {
        if (this.sample == null) {
            throw new RuntimeException("distribution is already provided for the categorical variable, cannot add observation");
        }
        Observation observation = new Observation();
        observation.setCategory(value);
        observation.setGroupId(groupId);
        this.sample.add(observation);
        if (this.group1Id.equals(groupId)) {
            this.sample1DistributionMap.remove(value);
        } else if (this.group2Id.equals(groupId)) {
            this.sample2DistributionMap.remove(value);
        }
        return this;
    }

    private String group1Id() {
        return this.group1Id;
    }

    private String group2Id() {
        return this.group2Id;
    }

    public Proportion proportion(String value, String groupId) {
        if (this.successLabel != null && !this.successLabel.equals(value)) {
            throw new RuntimeException("distribution is already provided with the success label that is different that the parameter");
        }
        SampleDistribution sampleDistribution = new SampleDistribution(this.sample, value);
        SamplingDistributionOfSampleProportion sds = new SamplingDistributionOfSampleProportion(sampleDistribution);
        return new Proportion(sds);
    }

    public ProportionDifference proportionDifference(String value) {
        return new ProportionDifference(this.getSamplingDistribution(value));
    }

    public SamplingDistributionOfSampleProportionDifference getSamplingDistribution(String value) {
        if (this.sample != null) {
            SampleDistribution distribution1 = this.getSampleDistribution1(value);
            SampleDistribution distribution2 = this.getSampleDistribution2(value);
            return new SamplingDistributionOfSampleProportionDifference(distribution1, distribution2);
        }
        return new SamplingDistributionOfSampleProportionDifference(this.sample1Proportion, this.sample2Proportion, this.sample1Size, this.sample2Size, this.group1Id, this.group2Id);
    }

    public SampleDistribution getSampleDistribution1(String value) {
        if (this.sample1DistributionMap.containsKey(value)) {
            return this.sample1DistributionMap.get(value);
        }
        SampleDistribution distribution = new SampleDistribution(this.sample, value, this.group1Id());
        this.sample1DistributionMap.put(value, distribution);
        return distribution;
    }

    public SampleDistribution getSampleDistribution2(String value) {
        if (this.sample2DistributionMap.containsKey(value)) {
            return this.sample2DistributionMap.get(value);
        }
        SampleDistribution distribution = new SampleDistribution(this.sample, value, this.group2Id());
        this.sample2DistributionMap.put(value, distribution);
        return distribution;
    }

    public TestingOnProportionDifference test4GroupDifference(String value) {
        if (this.successLabel != null && !this.successLabel.equals(value)) {
            throw new RuntimeException("distribution is already provided with the success label that is different that the parameter");
        }
        if (this.sample != null) {
            TestingOnProportionDifference test = new TestingOnProportionDifference();
            SampleDistribution distribution1 = this.getSampleDistribution1(value);
            SampleDistribution distribution2 = this.getSampleDistribution2(value);
            double pHat1 = distribution1.getProportion();
            double pHat2 = distribution2.getProportion();
            int n1 = distribution1.getSampleSize();
            int n2 = distribution2.getSampleSize();
            test.run(this.successLabel, pHat1, pHat2, n1, n2);
            return test;
        }
        TestingOnProportionDifference test = new TestingOnProportionDifference();
        test.run(this.successLabel, this.sample1Proportion, this.sample2Proportion, this.sample1Size, this.sample2Size);
        return test;
    }

    public void addObservations(DataFrame dataFrame) {
        for (int i = 0; i < dataFrame.rowCount(); ++i) {
            DataRow row = dataFrame.row(i);
            String value = row.getCategoricalCell(this.variable.getName());
            String groupId = row.getCategoricalCell(this.groupVariable.getName());
            this.addObservation(value, groupId);
        }
    }

    public double getGroup1SampleMean(String value) {
        return this.getSampleDistribution1(value).getSampleMean();
    }

    public double getGroup1SampleProportion(String value) {
        return this.getSampleDistribution1(value).getProportion();
    }

    public double getGroup1SampleSd(String value) {
        return this.getSampleDistribution1(value).getSampleSd();
    }

    public int getGroup1SampleSize() {
        if (this.sample != null) {
            return this.sample.countByGroupId(this.group1Id);
        }
        return this.sample1Size;
    }

    public double getGroup2SampleMean(String value) {
        return this.getSampleDistribution2(value).getSampleMean();
    }

    public double getGroup2SampleProportion(String value) {
        return this.getSampleDistribution2(value).getProportion();
    }

    public double getGroup2SampleSd(String value) {
        return this.getSampleDistribution2(value).getSampleSd();
    }

    public int getGroup2SampleSize() {
        if (this.sample != null) {
            return this.sample.countByGroupId(this.group2Id);
        }
        return this.sample2Size;
    }
}

