/*
 * Decompiled with CFR 0.152.
 */
package com.github.chen0040.si.dsl;

import com.github.chen0040.data.frame.DataFrame;
import com.github.chen0040.data.frame.DataRow;
import com.github.chen0040.si.dsl.Mean;
import com.github.chen0040.si.dsl.VariablePair;
import com.github.chen0040.si.statistics.Observation;
import com.github.chen0040.si.statistics.Sample;
import com.github.chen0040.si.statistics.SampleDistribution;
import com.github.chen0040.si.statistics.SamplingDistributionOfSampleMean;
import com.github.chen0040.si.testing.TestingOnValue;

public class PairedSampleKie {
    private Sample sample = new Sample();
    private VariablePair variablePair;
    private SampleDistribution sampleDistribution;
    private SamplingDistributionOfSampleMean samplingDistribution;

    public PairedSampleKie(VariablePair variablePair) {
        this.variablePair = variablePair;
    }

    public PairedSampleKie addObservation(double value1, double value2) {
        Observation observation = new Observation();
        observation.setX(value1 - value2);
        observation.setGroupId(this.groupId());
        this.sample.add(observation);
        this.sampleDistribution = null;
        this.samplingDistribution = null;
        return this;
    }

    private String groupId() {
        return this.variablePair.variable1().getName() + " - " + this.variablePair.variable2().getName();
    }

    public Mean difference() {
        SamplingDistributionOfSampleMean sds = this.getSamplingDistribution();
        return new Mean(sds);
    }

    public SampleDistribution getSampleDistribution() {
        if (this.sampleDistribution == null) {
            this.sampleDistribution = new SampleDistribution(this.sample, this.groupId());
        }
        return this.sampleDistribution;
    }

    public SamplingDistributionOfSampleMean getSamplingDistribution() {
        if (this.samplingDistribution == null) {
            SampleDistribution distribution = this.getSampleDistribution();
            this.samplingDistribution = new SamplingDistributionOfSampleMean(distribution);
        }
        return this.samplingDistribution;
    }

    public TestingOnValue testDifferenceEqualTo(double mean) {
        TestingOnValue test = new TestingOnValue();
        SampleDistribution distribution = this.getSampleDistribution();
        double xHat = distribution.getSampleMean();
        double sd = distribution.getSampleSd();
        int n = distribution.getSampleSize();
        test.run(xHat, sd, n, mean);
        return test;
    }

    public void addObservations(DataFrame dataFrame) {
        for (int i = 0; i < dataFrame.rowCount(); ++i) {
            DataRow row = dataFrame.row(i);
            this.addObservation(row.getCell(this.variablePair.variable1().getName()), row.getCell(this.variablePair.variable2().getName()));
        }
    }

    public double getSampleDifferenceMean() {
        return this.getSampleDistribution().getSampleMean();
    }

    public double getSampleDifferenceSd() {
        return this.getSampleDistribution().getSampleSd();
    }

    public int getSampleSize() {
        return this.getSampleDistribution().getSampleSize();
    }
}

