/*
 * Decompiled with CFR 0.152.
 */
package com.github.chen0040.si.dsl;

import com.github.chen0040.data.frame.DataFrame;
import com.github.chen0040.data.frame.DataRow;
import com.github.chen0040.si.dsl.Mean;
import com.github.chen0040.si.dsl.Variable;
import com.github.chen0040.si.statistics.Observation;
import com.github.chen0040.si.statistics.Sample;
import com.github.chen0040.si.statistics.SampleDistribution;
import com.github.chen0040.si.statistics.SamplingDistributionOfSampleMean;
import com.github.chen0040.si.testing.TestingOnValue;

public class NumericalSampleKie {
    private Sample sample = new Sample();
    private double sampleMean;
    private double sampleSd;
    private int sampleSize;
    private SampleDistribution sampleDistribution = null;
    private SamplingDistributionOfSampleMean samplingDistributionOfSampleMean = null;
    private final Variable variable;

    public NumericalSampleKie(Variable variable) {
        this.variable = variable;
    }

    public NumericalSampleKie fromSampleDistribution(double sampleMean, double sampleSd, int sampleSize) {
        this.sample = null;
        this.sampleMean = sampleMean;
        this.sampleSize = sampleSize;
        this.sampleSd = sampleSd;
        this.sampleDistribution = new SampleDistribution(sampleMean, sampleSize, sampleSd, this.groupId());
        this.samplingDistributionOfSampleMean = new SamplingDistributionOfSampleMean(sampleMean, sampleSize, sampleSd, this.groupId());
        return this;
    }

    public NumericalSampleKie addObservation(double value) {
        if (this.sample == null) {
            throw new RuntimeException("distribution is already provided, cannot add observation");
        }
        Observation observation = new Observation();
        observation.setX(value);
        observation.setGroupId(this.groupId());
        this.sample.add(observation);
        this.sampleDistribution = null;
        this.samplingDistributionOfSampleMean = null;
        return this;
    }

    public NumericalSampleKie addObservations(DataFrame dataFrame) {
        for (int i = 0; i < dataFrame.rowCount(); ++i) {
            DataRow row = dataFrame.row(i);
            double value = row.getCell(this.variable.getName());
            this.addObservation(value);
        }
        return this;
    }

    public SampleDistribution getSampleDistribution() {
        if (this.sampleDistribution == null) {
            this.sampleDistribution = new SampleDistribution(this.sample, this.groupId());
        }
        return this.sampleDistribution;
    }

    public SamplingDistributionOfSampleMean getSamplingDistribution() {
        if (this.samplingDistributionOfSampleMean == null) {
            this.samplingDistributionOfSampleMean = new SamplingDistributionOfSampleMean(this.getSampleDistribution());
        }
        return this.samplingDistributionOfSampleMean;
    }

    public Mean mean() {
        return new Mean(this.getSamplingDistribution());
    }

    private String groupId() {
        return this.variable.getName();
    }

    public TestingOnValue test4MeanEqualTo(double mean) {
        if (this.sample != null) {
            TestingOnValue test = new TestingOnValue();
            SampleDistribution distribution = this.getSampleDistribution();
            double xHat = distribution.getSampleMean();
            double sd = distribution.getSampleSd();
            int n = distribution.getSampleSize();
            test.run(xHat, sd, n, mean);
            return test;
        }
        TestingOnValue test = new TestingOnValue();
        test.run(this.sampleMean, this.sampleSd, this.sampleSize, mean);
        return test;
    }

    public double getSampleMean() {
        return this.getSampleDistribution().getSampleMean();
    }

    public double getSampleSd() {
        return this.getSampleDistribution().getSampleSd();
    }

    public double getSampleSize() {
        return this.getSampleDistribution().getSampleSize();
    }

    public void addObservations(double[] values) {
        double[] dArray = values;
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            Double value = dArray[i];
            this.addObservation(value);
        }
    }
}

