/*
 * Decompiled with CFR 0.152.
 */
package com.github.chen0040.si.dsl;

import com.github.chen0040.data.frame.DataFrame;
import com.github.chen0040.data.frame.DataRow;
import com.github.chen0040.si.dsl.Variable;
import com.github.chen0040.si.statistics.Observation;
import com.github.chen0040.si.statistics.Sample;
import com.github.chen0040.si.statistics.SampleDistribution;
import com.github.chen0040.si.testing.Anova;
import java.util.Map;

public class CategoricalToNumericalSampleKie {
    private final Variable variable;
    private final Variable groupVariable;
    private Sample sample;
    private SampleDistribution sampleDistributionTotal;
    private Map<String, SampleDistribution> sampleDistributionByGroupId;

    public CategoricalToNumericalSampleKie(Variable variable, Variable groupVariable) {
        this.variable = variable;
        this.groupVariable = groupVariable;
    }

    public CategoricalToNumericalSampleKie addObservation(double value, String groupId) {
        if (this.sample == null) {
            this.sample = new Sample();
        }
        Observation observation = new Observation();
        observation.setX(value);
        observation.setGroupId(groupId);
        this.sample.add(observation);
        return this;
    }

    public CategoricalToNumericalSampleKie fromSampleDistributions(SampleDistribution sampleDistributionTotal, Map<String, SampleDistribution> sampleDistributionByGroupId) {
        this.sampleDistributionByGroupId = sampleDistributionByGroupId;
        this.sampleDistributionTotal = sampleDistributionTotal;
        return this;
    }

    public Anova test4Independence() {
        if (this.sample != null) {
            return new Anova(this.sample);
        }
        return new Anova().run(this.sampleDistributionTotal, this.sampleDistributionByGroupId);
    }

    public void addObservations(DataFrame dataFrame) {
        for (int i = 0; i < dataFrame.rowCount(); ++i) {
            DataRow row = dataFrame.row(i);
            double value = row.getCell(this.variable.getName());
            String groupId = row.getCategoricalCell(this.groupVariable.getName());
            this.addObservation(value, groupId);
        }
    }
}

