/*
 * Decompiled with CFR 0.152.
 */
package com.github.chen0040.si.dsl;

import com.github.chen0040.data.frame.DataFrame;
import com.github.chen0040.data.frame.DataRow;
import com.github.chen0040.si.dsl.Variable;
import com.github.chen0040.si.statistics.ContingencyTable;
import com.github.chen0040.si.statistics.Observation;
import com.github.chen0040.si.statistics.Sample;
import com.github.chen0040.si.testing.ChiSquareTest;

public class CategoricalToCategoricalSampleKie {
    private final Variable variable;
    private final Variable groupVariable;
    private Sample sample;
    private ContingencyTable contingencyTable;

    public CategoricalToCategoricalSampleKie(Variable variable, Variable groupVariable) {
        this.variable = variable;
        this.groupVariable = groupVariable;
    }

    public CategoricalToCategoricalSampleKie addObservation(String value, String groupId) {
        if (this.sample == null) {
            this.sample = new Sample();
        }
        Observation observation = new Observation();
        observation.setCategory(value);
        observation.setGroupId(groupId);
        this.sample.add(observation);
        this.contingencyTable = null;
        return this;
    }

    public CategoricalToCategoricalSampleKie fromContingencyTable(ContingencyTable table) {
        this.contingencyTable = table;
        return this;
    }

    public ChiSquareTest test4Independence() {
        if (this.sample != null) {
            return new ChiSquareTest().run(this.getOrCreateContingencyTable());
        }
        return new ChiSquareTest().run(this.contingencyTable);
    }

    public ContingencyTable getOrCreateContingencyTable() {
        if (this.contingencyTable == null && this.sample != null) {
            this.contingencyTable = new ContingencyTable(this.sample);
        }
        return this.contingencyTable;
    }

    public void addObservations(DataFrame dataFrame) {
        for (int i = 0; i < dataFrame.rowCount(); ++i) {
            DataRow row = dataFrame.row(i);
            String value = row.getCategoricalCell(this.variable.getName());
            String groupId = row.getCategoricalCell(this.groupVariable.getName());
            this.addObservation(value, groupId);
        }
    }
}

