/*
 * Decompiled with CFR 0.152.
 */
package com.github.chen0040.si.dsl;

import com.github.chen0040.data.frame.DataFrame;
import com.github.chen0040.data.frame.DataRow;
import com.github.chen0040.si.dsl.Proportion;
import com.github.chen0040.si.dsl.Variable;
import com.github.chen0040.si.statistics.Observation;
import com.github.chen0040.si.statistics.Sample;
import com.github.chen0040.si.statistics.SampleDistribution;
import com.github.chen0040.si.statistics.SamplingDistributionOfSampleProportion;
import com.github.chen0040.si.testing.TestingOnProportion;

public class CategoricalSampleKie {
    private final Variable variable;
    private Sample sample;
    private double sampleProportion;
    private int sampleSize;
    private String successLabel;

    public CategoricalSampleKie(Variable variable) {
        this.variable = variable;
        this.sample = new Sample();
        this.successLabel = null;
    }

    public CategoricalSampleKie fromSampleDistribution(String successLabel, double sampleProportion, int sampleSize) {
        this.sampleProportion = sampleProportion;
        this.sampleSize = sampleSize;
        this.successLabel = successLabel;
        return this;
    }

    public CategoricalSampleKie addObservation(String value) {
        if (this.sample == null) {
            throw new RuntimeException("distribution is already provided for the categorical variable, cannot add observation");
        }
        Observation observation = new Observation();
        observation.setCategory(value);
        observation.setGroupId(this.groupId());
        this.sample.add(observation);
        return this;
    }

    public CategoricalSampleKie addObservations(DataFrame dataFrame) {
        for (int i = 0; i < dataFrame.rowCount(); ++i) {
            DataRow row = dataFrame.row(i);
            String value = row.getCategoricalCell(this.variable.getName());
            this.addObservation(value);
        }
        return this;
    }

    public CategoricalSampleKie addObservations(String[] values) {
        for (String value : values) {
            this.addObservation(value);
        }
        return this;
    }

    private String groupId() {
        return this.variable.getName();
    }

    public Proportion proportion(String value) {
        if (this.successLabel != null && !this.successLabel.equals(value)) {
            throw new RuntimeException("distribution is already provided with the success label that is different that the parameter");
        }
        SamplingDistributionOfSampleProportion sds = this.getSamplingDistribution(value);
        return new Proportion(sds);
    }

    public SampleDistribution getSampleDistribution(String value) {
        if (this.sample == null) {
            return new SampleDistribution(this.successLabel, this.sampleProportion, this.sampleSize, this.groupId());
        }
        return new SampleDistribution(this.sample, value, this.groupId());
    }

    public SamplingDistributionOfSampleProportion getSamplingDistribution(String value) {
        SampleDistribution sampleDistribution = this.getSampleDistribution(value);
        return new SamplingDistributionOfSampleProportion(sampleDistribution);
    }

    public TestingOnProportion test4ProportionEqualTo(String value, double p) {
        if (this.successLabel != null && !this.successLabel.equals(value)) {
            throw new RuntimeException("distribution is already provided with the success label that is different that the parameter");
        }
        if (this.sample != null) {
            TestingOnProportion test = new TestingOnProportion();
            SampleDistribution distribution = new SampleDistribution(this.sample, value, this.groupId());
            double pHat = distribution.getProportion();
            int n = distribution.getSampleSize();
            test.run(value, pHat, n, p);
            return test;
        }
        TestingOnProportion test = new TestingOnProportion();
        test.run(value, this.sampleProportion, this.sampleSize, p);
        return test;
    }

    public double getSampleMean(String value) {
        return this.getSampleDistribution(value).getSampleMean();
    }

    public double getSampleProportion(String value) {
        return this.getSampleDistribution(value).getProportion();
    }

    public double getSampleSd(String value) {
        return this.getSampleDistribution(value).getSampleSd();
    }

    public double getSampleSize() {
        if (this.sample != null) {
            return this.sample.countByGroupId(this.groupId());
        }
        return this.sampleSize;
    }
}

