/*
 * Decompiled with CFR 0.152.
 */
package com.github.chen0040.magento.services;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.github.chen0040.magento.MagentoClient;
import com.github.chen0040.magento.models.MagentoAttributeType;
import com.github.chen0040.magento.models.MagentoType;
import com.github.chen0040.magento.models.Product;
import com.github.chen0040.magento.models.ProductAttributePage;
import com.github.chen0040.magento.models.ProductPage;
import com.github.chen0040.magento.services.MagentoHttpComponent;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MagentoProductManager
extends MagentoHttpComponent {
    private static final Logger logger = LoggerFactory.getLogger(MagentoProductManager.class);
    private MagentoClient client;
    private static final String relativePath4Products = "rest/V1/products";

    public MagentoProductManager(MagentoClient client) {
        super(client.getHttpComponent());
        this.client = client;
    }

    @Override
    public String token() {
        return this.client.token();
    }

    @Override
    public String baseUri() {
        return this.client.baseUri();
    }

    public ProductPage page(int pageIndex, int pageSize) {
        String uri = this.baseUri() + "/" + relativePath4Products + "?searchCriteria[currentPage]=" + pageIndex + "&searchCriteria[pageSize]=" + pageSize;
        String json = this.getSecured(uri);
        if (!this.validate(json)) {
            return null;
        }
        return (ProductPage)JSON.parseObject((String)json, ProductPage.class);
    }

    public Product getProductBySku(String sku) {
        String uri = this.baseUri() + "/" + relativePath4Products + "/" + this.escape(sku);
        String json = this.getSecured(uri);
        if (!this.validate(json)) {
            return null;
        }
        return (Product)JSON.parseObject((String)json, Product.class);
    }

    public List<MagentoAttributeType> getProductAttributeTypes() {
        String uri = this.baseUri() + "/rest/V1/products/attributes/types";
        String json = this.getSecured(uri);
        if (!this.validate(json)) {
            return null;
        }
        return JSON.parseArray((String)json, MagentoAttributeType.class);
    }

    public ProductAttributePage getProductAttributes(int pageIndex, int pageSize) {
        String uri = this.baseUri() + "/rest/V1/products/attributes" + "?searchCriteria[currentPage]=" + pageIndex + "&searchCriteria[pageSize]=" + pageSize;
        String json = this.getSecured(uri);
        if (!this.validate(json)) {
            return null;
        }
        return (ProductAttributePage)JSON.parseObject((String)json, ProductAttributePage.class);
    }

    public boolean hasProduct(String sku) {
        return this.getProductBySku(sku) != null;
    }

    public Product addProduct(Product product) {
        String sku = product.getSku();
        String url = this.baseUri() + "/" + relativePath4Products + "/" + this.escape(sku);
        HashMap<String, Object> detail = new HashMap<String, Object>();
        detail.put("sku", product.getSku());
        detail.put("name", product.getName());
        detail.put("price", product.getPrice());
        detail.put("status", product.getStatus());
        detail.put("type_id", product.getType_id());
        detail.put("attribute_set_id", product.getAttribute_set_id());
        detail.put("weight", product.getWeight());
        HashMap<String, HashMap<String, Object>> req = new HashMap<String, HashMap<String, Object>>();
        req.put("product", detail);
        String body = JSON.toJSONString(req, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat});
        logger.info("posting:\r\n{}", (Object)body);
        String json = this.putSecure(url, body);
        if (!this.validate(json)) {
            return null;
        }
        return (Product)JSON.parseObject((String)json, Product.class);
    }

    public String page(String name, String value, String condition_type) {
        String uri = this.baseUri() + "/" + relativePath4Products + "?searchCriteria[filter_groups][0][filters][0][field]=category_gear" + "&searchCriteria[filter_groups][0][filters][0][value]=86" + "&searchCriteria[filter_groups][0][filters][0][condition_type]=finset";
        return this.getSecured(uri);
    }

    public List<MagentoType> listProductTypes() {
        String uri = this.baseUri() + "/rest/V1/products/types" + "?searchCriteria[currentPage]=0" + "&searchCriteria[pageSize]=1000";
        String json = this.getSecured(uri);
        return JSON.parseArray((String)json, MagentoType.class);
    }

    public List<MagentoType> listProductTypes(int page, int pageSize) {
        String uri = this.baseUri() + "/rest/V1/products/types" + "?searchCriteria[currentPage]=" + page + "&searchCriteria[pageSize]=" + pageSize;
        String json = this.getSecured(uri);
        return JSON.parseArray((String)json, MagentoType.class);
    }

    public String deleteProduct(String sku) {
        String url = this.baseUri() + "/" + relativePath4Products + "/" + this.escape(sku);
        return this.deleteSecure(url);
    }
}

