/*
 * Decompiled with CFR 0.152.
 */
package com.github.chen0040.magento.services;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.github.chen0040.magento.services.HttpComponent;
import com.github.chen0040.magento.utils.StringUtils;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MagentoHttpComponent {
    private static final Logger logger = LoggerFactory.getLogger(MagentoHttpComponent.class);
    private HttpComponent httpComponent;

    public abstract String token();

    public abstract String baseUri();

    public MagentoHttpComponent(HttpComponent httpComponent) {
        this.httpComponent = httpComponent;
    }

    public String postSecure(String url, String body) {
        HashMap<String, String> headers = new HashMap<String, String>();
        if (!StringUtils.isEmpty(this.token())) {
            headers.put("Authorization", "Bearer " + this.token());
        }
        headers.put("Content-Type", "application/json");
        return this.httpComponent.post(url, body, headers);
    }

    public String putSecure(String url, String body) {
        HashMap<String, String> headers = new HashMap<String, String>();
        if (!StringUtils.isEmpty(this.token())) {
            headers.put("Authorization", "Bearer " + this.token());
        }
        headers.put("Content-Type", "application/json");
        return this.httpComponent.put(url, body, headers);
    }

    public String deleteSecure(String url) {
        HashMap<String, String> headers = new HashMap<String, String>();
        if (!StringUtils.isEmpty(this.token())) {
            headers.put("Authorization", "Bearer " + this.token());
        }
        headers.put("Content-Type", "application/json");
        return this.httpComponent.delete(url, headers);
    }

    public String getSecured(String uri) {
        HashMap<String, String> headers = new HashMap<String, String>();
        if (!StringUtils.isEmpty(this.token())) {
            headers.put("Authorization", "Bearer " + this.token());
        }
        headers.put("Content-Type", "application/json");
        return this.httpComponent.get(uri, headers);
    }

    public String escape(String text) {
        String result = text;
        try {
            result = URLEncoder.encode(text, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            logger.error("Failed to escape " + text, (Throwable)e);
        }
        return result;
    }

    protected boolean validate(String json) {
        try {
            Map data = (Map)JSON.parseObject((String)json, (Type)new TypeReference<Map<String, Object>>(){}.getType(), (Feature[])new Feature[0]);
            if (data.containsKey("message")) {
                logger.error("query failed: {}", data.get("message"));
                logger.warn("trace: {}", data.get("trace"));
                return false;
            }
        }
        catch (JSONException exception) {
            return true;
        }
        return true;
    }
}

