/*
 * Decompiled with CFR 0.152.
 */
package com.github.chen0040.magento;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.github.chen0040.magento.models.Account;
import com.github.chen0040.magento.services.BasicHttpComponent;
import com.github.chen0040.magento.services.HttpComponent;
import com.github.chen0040.magento.services.MagentoCategoryManager;
import com.github.chen0040.magento.services.MagentoHttpComponent;
import com.github.chen0040.magento.services.MagentoInventoryStockManager;
import com.github.chen0040.magento.services.MagentoProductManager;
import com.github.chen0040.magento.services.MagentoProductMediaManager;
import com.github.chen0040.magento.utils.StringUtils;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MagentoClient
extends MagentoHttpComponent
implements Serializable {
    private static final long serialVersionUID = 3001998767951271632L;
    private static final String relativePath4LoginAsClient = "rest/V1/integration/customer/token";
    private static final String relativePath4LoginAsAdmin = "rest/V1/integration/admin/token";
    private static final Logger logger = LoggerFactory.getLogger(MagentoClient.class);
    private String token = null;
    private String baseUri = "";
    private boolean admin = false;
    private boolean authenticated = false;
    private MagentoProductManager products;
    private MagentoCategoryManager categories;
    private MagentoInventoryStockManager inventory;
    private MagentoProductMediaManager media;
    private HttpComponent httpComponent;

    public MagentoClient(String baseUri, HttpComponent httpComponent) {
        super(httpComponent);
        this.baseUri = baseUri;
        this.products = new MagentoProductManager(this);
        this.categories = new MagentoCategoryManager(this);
        this.inventory = new MagentoInventoryStockManager(this);
        this.media = new MagentoProductMediaManager(this);
    }

    public MagentoClient(String baseUri) {
        super(new BasicHttpComponent());
        this.baseUri = baseUri;
        this.products = new MagentoProductManager(this);
        this.categories = new MagentoCategoryManager(this);
        this.inventory = new MagentoInventoryStockManager(this);
        this.media = new MagentoProductMediaManager(this);
    }

    public Account getMyAccount() {
        if (this.admin) {
            logger.warn("my account access api is not supported for admin rest call");
            return null;
        }
        String uri = this.baseUri + "/rest/V1/customers/me";
        String json = this.getSecured(uri);
        if (!this.validate(json)) {
            return null;
        }
        return (Account)JSON.parseObject((String)json, Account.class);
    }

    public Map<String, Object> getAccountById(long id) {
        if (!this.admin) {
            logger.warn("other account access api is not supported for client rest call");
            return new HashMap<String, Object>();
        }
        String uri = this.baseUri + "/rest/V1/customers/" + id;
        String json = this.getSecured(uri);
        Map data = (Map)JSON.parseObject((String)json, (Type)new TypeReference<Map<String, Object>>(){}.getType(), (Feature[])new Feature[0]);
        return data;
    }

    public String loginAsClient(String username, String password) {
        String uri = this.baseUri + "/" + relativePath4LoginAsClient;
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("username", username);
        data.put("password", password);
        this.token = StringUtils.stripQuotation(this.httpComponent.jsonPost(uri, data));
        logger.info("loginAsClient returns: {}", (Object)this.token);
        if (!this.token.contains("Invalid login or password")) {
            this.authenticated = true;
        }
        return this.token;
    }

    public String loginAsAdmin(String username, String password) {
        String uri = this.baseUri + "/" + relativePath4LoginAsAdmin;
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("username", username);
        data.put("password", password);
        this.token = StringUtils.stripQuotation(this.httpComponent.jsonPost(uri, data));
        logger.info("loginAsClient returns: {}", (Object)this.token);
        if (!this.token.contains("Invalid login or password")) {
            this.authenticated = true;
        }
        return this.token;
    }

    public MagentoCategoryManager categories() {
        return this.categories;
    }

    public MagentoProductManager products() {
        return this.products;
    }

    public MagentoInventoryStockManager inventory() {
        return this.inventory;
    }

    public MagentoProductMediaManager media() {
        return this.media;
    }

    @Override
    public String token() {
        return this.token;
    }

    @Override
    public String baseUri() {
        return this.baseUri;
    }

    public String getToken() {
        return this.token;
    }

    public String getBaseUri() {
        return this.baseUri;
    }

    public boolean isAdmin() {
        return this.admin;
    }

    public boolean isAuthenticated() {
        return this.authenticated;
    }

    public MagentoProductManager getProducts() {
        return this.products;
    }

    public MagentoCategoryManager getCategories() {
        return this.categories;
    }

    public MagentoInventoryStockManager getInventory() {
        return this.inventory;
    }

    public MagentoProductMediaManager getMedia() {
        return this.media;
    }

    public HttpComponent getHttpComponent() {
        return this.httpComponent;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public void setBaseUri(String baseUri) {
        this.baseUri = baseUri;
    }

    public void setAdmin(boolean admin) {
        this.admin = admin;
    }

    public void setAuthenticated(boolean authenticated) {
        this.authenticated = authenticated;
    }

    public void setProducts(MagentoProductManager products) {
        this.products = products;
    }

    public void setCategories(MagentoCategoryManager categories) {
        this.categories = categories;
    }

    public void setInventory(MagentoInventoryStockManager inventory) {
        this.inventory = inventory;
    }

    public void setMedia(MagentoProductMediaManager media) {
        this.media = media;
    }

    public void setHttpComponent(HttpComponent httpComponent) {
        this.httpComponent = httpComponent;
    }
}

