/*
 * Decompiled with CFR 0.152.
 */
package com.github.chen0040.glm.search.methods.naive;

import com.github.chen0040.glm.search.CostEvaluationMethod;
import com.github.chen0040.glm.search.GradientEvaluationMethod;
import com.github.chen0040.glm.search.LocalSearch;
import com.github.chen0040.glm.search.TerminationEvaluationMethod;
import com.github.chen0040.glm.search.solutions.NumericSolution;
import com.github.chen0040.glm.search.solutions.NumericSolutionUpdateResult;

public class SweepingSearch
extends LocalSearch {
    private int intervalCount = 100;

    @Override
    public void copy(LocalSearch rhs) {
        super.copy(rhs);
        SweepingSearch rhs2 = (SweepingSearch)rhs;
        this.intervalCount = rhs2.intervalCount;
    }

    @Override
    public LocalSearch makeCopy() {
        SweepingSearch clone = new SweepingSearch();
        clone.copy(this);
        return clone;
    }

    @Override
    public NumericSolution minimize(double[] x_0, CostEvaluationMethod evaluate, GradientEvaluationMethod calc_gradient, TerminationEvaluationMethod should_terminate, Object constraint) {
        NumericSolution best_solution = new NumericSolution();
        double[] x = (double[])x_0.clone();
        double fx = evaluate.apply(x, this.getLowerBounds(), this.getUpperBounds(), constraint);
        best_solution.tryUpdateSolution(x, fx);
        int iteration = 0;
        NumericSolutionUpdateResult state = null;
        int m = x.length;
        int L = 0;
        for (int i = 0; i < m; ++i) {
            L = L * this.intervalCount + (this.intervalCount - 1);
        }
        while (L > 0) {
            double fx_next;
            double[] x_next = this.create(this.getLowerBounds(), this.getUpperBounds(), L);
            state = best_solution.tryUpdateSolution(x_next, fx_next = evaluate.apply(x_next, this.getLowerBounds(), this.getUpperBounds(), constraint));
            if (state.improved()) {
                this.notifySolutionUpdated(best_solution, state, iteration);
            }
            this.step(new NumericSolution(x_next, fx_next), state, iteration);
            --L;
            ++iteration;
        }
        return best_solution;
    }

    private double[] create(double[] lower, double[] upper, int L) {
        int m = lower.length;
        int[] indices = new int[m];
        for (int i = 0; i < m; ++i) {
            int index;
            indices[i] = index = L % this.intervalCount;
            L /= this.intervalCount;
        }
        double[] x = new double[m];
        for (int i = 0; i < m; ++i) {
            x[i] = lower[i] + (double)indices[i] * (upper[i] - lower[i]) / (double)this.intervalCount;
        }
        return x;
    }
}

