/*
 * Decompiled with CFR 0.152.
 */
package com.github.chen0040.glm.search.methods.naive;

import com.github.chen0040.glm.search.CostEvaluationMethod;
import com.github.chen0040.glm.search.GradientEvaluationMethod;
import com.github.chen0040.glm.search.LocalSearch;
import com.github.chen0040.glm.search.TerminationEvaluationMethod;
import com.github.chen0040.glm.search.solutions.NumericSolution;
import com.github.chen0040.glm.search.solutions.NumericSolutionUpdateResult;
import java.util.Random;

public class RandomSearch
extends LocalSearch {
    private static Random rand = new Random();

    @Override
    public LocalSearch makeCopy() {
        RandomSearch clone = new RandomSearch();
        clone.copy(this);
        return clone;
    }

    @Override
    public NumericSolution minimize(double[] x_0, CostEvaluationMethod evaluate, GradientEvaluationMethod calc_gradient, TerminationEvaluationMethod should_terminate, Object constraint) {
        NumericSolution best_solution = new NumericSolution();
        double[] x = (double[])x_0.clone();
        double fx = evaluate.apply(x, this.getLowerBounds(), this.getUpperBounds(), constraint);
        best_solution.tryUpdateSolution(x, fx);
        int iteration = 0;
        NumericSolutionUpdateResult state = null;
        while (!should_terminate.shouldTerminate(state, iteration)) {
            double fx_next;
            double[] x_next = this.createRandom(this.getLowerBounds(), this.getUpperBounds());
            state = best_solution.tryUpdateSolution(x_next, fx_next = evaluate.apply(x_next, this.getLowerBounds(), this.getUpperBounds(), constraint));
            if (state.improved()) {
                this.notifySolutionUpdated(best_solution, state, iteration);
            }
            this.step(new NumericSolution(x_next, fx_next), state, iteration);
            ++iteration;
        }
        return best_solution;
    }

    public double[] createRandom(double[] lower, double[] upper) {
        double[] x = new double[lower.length];
        for (int i = 0; i < x.length; ++i) {
            x[i] = lower[i] + rand.nextDouble() * (upper[i] - lower[i]);
        }
        return x;
    }
}

