/*
 * Decompiled with CFR 0.152.
 */
package com.github.chen0040.glm.search.methods.cgs;

import com.github.chen0040.glm.search.CostEvaluationMethod;
import com.github.chen0040.glm.search.GradientEvaluationMethod;
import com.github.chen0040.glm.search.LineSearch;
import com.github.chen0040.glm.search.LineSearchResult;
import com.github.chen0040.glm.search.LocalSearch;
import com.github.chen0040.glm.search.TerminationEvaluationMethod;
import com.github.chen0040.glm.search.methods.cgs.BetaFormula;
import com.github.chen0040.glm.search.solutions.NumericSolution;
import com.github.chen0040.glm.search.solutions.NumericSolutionFactory;
import com.github.chen0040.glm.search.solutions.NumericSolutionUpdateResult;

public class NonlinearCGSearch
extends LocalSearch {
    private BetaFormula betaFormula = BetaFormula.FletcherReeves;

    @Override
    public void copy(LocalSearch rhs) {
        super.copy(rhs);
        NonlinearCGSearch rhs2 = (NonlinearCGSearch)rhs;
        this.betaFormula = rhs2.betaFormula;
    }

    @Override
    public LocalSearch makeCopy() {
        NonlinearCGSearch clone = new NonlinearCGSearch();
        clone.copy(this);
        return clone;
    }

    public void setBetaFormula(BetaFormula formula) {
        this.betaFormula = formula;
    }

    @Override
    public NumericSolution minimize(double[] x_0, CostEvaluationMethod evaluate, GradientEvaluationMethod calc_gradient, TerminationEvaluationMethod should_terminate, Object constraint) {
        NumericSolution best_solution = new NumericSolution();
        int dimension = x_0.length;
        double[] x = (double[])x_0.clone();
        double fx = evaluate.apply(x, this.getLowerBounds(), this.getUpperBounds(), constraint);
        double[] Vfx = new double[dimension];
        calc_gradient.apply(x, Vfx, this.getLowerBounds(), this.getUpperBounds(), constraint);
        double[] deltaX = new double[dimension];
        double[] deltaX_prev = new double[dimension];
        for (int d = 0; d < dimension; ++d) {
            deltaX[d] = -Vfx[d];
        }
        LineSearchResult result = LineSearch.search(x, fx, deltaX, evaluate, calc_gradient, this.getLowerBounds(), this.getUpperBounds(), constraint);
        double alpha = result.alpha();
        double[] x_next = result.x();
        double fx_next = result.fx();
        double beta = 0.0;
        double[] s = new double[dimension];
        for (int d = 0; d < dimension; ++d) {
            s[d] = deltaX[d];
        }
        int iteration = 0;
        NumericSolutionUpdateResult state = null;
        while (!should_terminate.shouldTerminate(state, iteration)) {
            int d;
            for (d = 0; d < dimension; ++d) {
                deltaX_prev[d] = deltaX[d];
                x[d] = x_next[d];
            }
            calc_gradient.apply(x, Vfx, this.getLowerBounds(), this.getUpperBounds(), constraint);
            for (d = 0; d < dimension; ++d) {
                deltaX[d] = -Vfx[d];
            }
            beta = this.computeBeta(deltaX, deltaX_prev, s);
            for (d = 0; d < dimension; ++d) {
                s[d] = deltaX[d] + beta * s[d];
            }
            result = LineSearch.search(x, fx, s, evaluate, calc_gradient, this.getLowerBounds(), this.getUpperBounds(), constraint);
            x_next = result.x();
            fx_next = result.fx();
            alpha = result.alpha();
            state = best_solution.tryUpdateSolution(x_next, fx_next);
            if (state.improved()) {
                this.notifySolutionUpdated(best_solution, state, iteration);
            }
            this.step(new NumericSolution(x_next, fx_next), state, iteration);
            ++iteration;
        }
        return best_solution;
    }

    public double[] randomize(double[] x) {
        return NumericSolutionFactory.mutate(x, 5.0);
    }

    public double computeBeta(double[] deltaX, double[] deltaX_prev, double[] s) {
        double beta = 0.0;
        int dimension = deltaX.length;
        if (this.betaFormula == BetaFormula.FletcherReeves) {
            double num1 = 0.0;
            for (int d = 0; d < dimension; ++d) {
                num1 += Math.pow(deltaX[d], 2.0);
            }
            double num2 = 0.0;
            for (int d = 0; d < dimension; ++d) {
                num2 += Math.pow(deltaX_prev[d], 2.0);
            }
            if (num2 != 0.0) {
                beta = num1 / num2;
            }
        } else if (this.betaFormula == BetaFormula.HestenesStiefel) {
            double num1 = 0.0;
            for (int d = 0; d < dimension; ++d) {
                num1 += deltaX[d] * (deltaX[d] - deltaX_prev[d]);
            }
            double num2 = 0.0;
            for (int d = 0; d < dimension; ++d) {
                num2 += Math.pow(deltaX_prev[d], 2.0);
            }
            if (num2 != 0.0) {
                beta = num1 / num2;
            }
        } else if (this.betaFormula == BetaFormula.PolakRebiere) {
            double num1 = 0.0;
            for (int d = 0; d < dimension; ++d) {
                num1 += deltaX[d] * (deltaX[d] - deltaX_prev[d]);
            }
            double num2 = 0.0;
            for (int d = 0; d < dimension; ++d) {
                num2 += s[d] * (deltaX[d] - deltaX_prev[d]);
            }
            if (num2 != 0.0) {
                beta = num1 / num2;
            }
        }
        return beta;
    }
}

