/*
 * Decompiled with CFR 0.152.
 */
package com.github.chen0040.glm.search;

import com.github.chen0040.glm.search.events.NumericSolutionIterateListener;
import com.github.chen0040.glm.search.events.NumericSolutionUpdatedListener;
import com.github.chen0040.glm.search.solutions.NumericSolution;
import com.github.chen0040.glm.search.solutions.NumericSolutionUpdateResult;
import java.util.HashSet;

public class SearchListenerService {
    private HashSet<NumericSolutionIterateListener> iterateListeners = new HashSet();
    private HashSet<NumericSolutionUpdatedListener> updateListeners = new HashSet();

    public void addIterateListener(NumericSolutionIterateListener listener) {
        this.iterateListeners.add(listener);
    }

    public void removeIterateListener(NumericSolutionIterateListener listener) {
        this.iterateListeners.remove(listener);
    }

    public void addUpdateListener(NumericSolutionUpdatedListener listener) {
        this.updateListeners.add(listener);
    }

    public void removeUpdateListener(NumericSolutionUpdatedListener listener) {
        this.updateListeners.remove(listener);
    }

    public void notifySolutionUpdated(NumericSolution solution, NumericSolutionUpdateResult state, int iteration) {
        for (NumericSolutionUpdatedListener listener : this.updateListeners) {
            if (listener == null) continue;
            listener.report(solution, state, iteration);
        }
    }

    public void step(NumericSolution solution, NumericSolutionUpdateResult state, int iteration) {
        for (NumericSolutionIterateListener listener : this.iterateListeners) {
            if (listener == null) continue;
            listener.report(solution, state, iteration);
        }
    }
}

