/*
 * Decompiled with CFR 0.152.
 */
package com.github.chen0040.glm.search;

import com.github.chen0040.glm.search.CostEvaluationMethod;
import com.github.chen0040.glm.search.CostFunction;
import com.github.chen0040.glm.search.GradientEstimation;
import com.github.chen0040.glm.search.GradientEvaluationMethod;
import com.github.chen0040.glm.search.SearchListenerService;
import com.github.chen0040.glm.search.TerminationEvaluationMethod;
import com.github.chen0040.glm.search.events.NumericSolutionIterateListener;
import com.github.chen0040.glm.search.events.NumericSolutionUpdatedListener;
import com.github.chen0040.glm.search.solutions.NumericSolution;
import com.github.chen0040.glm.search.solutions.NumericSolutionUpdateResult;
import java.util.Random;
import sun.reflect.generics.reflectiveObjects.NotImplementedException;

public abstract class LocalSearch
implements Cloneable {
    private static Random rand = new Random();
    private double[] upperBounds;
    private double[] lowerBounds;
    private SearchListenerService listenerService = new SearchListenerService();

    public void copy(LocalSearch rhs) {
        this.upperBounds = rhs.upperBounds == null ? null : (double[])rhs.upperBounds.clone();
        this.lowerBounds = rhs.lowerBounds == null ? null : (double[])rhs.lowerBounds.clone();
    }

    public LocalSearch makeCopy() {
        throw new NotImplementedException();
    }

    public void addIterateListener(NumericSolutionIterateListener listener) {
        this.listenerService.addIterateListener(listener);
    }

    public void removeIterateListener(NumericSolutionIterateListener listener) {
        this.listenerService.removeIterateListener(listener);
    }

    public void addUpdateListener(NumericSolutionUpdatedListener listener) {
        this.listenerService.addUpdateListener(listener);
    }

    public void removeUpdateListener(NumericSolutionUpdatedListener listener) {
        this.listenerService.removeUpdateListener(listener);
    }

    public double[] getUpperBounds() {
        return this.upperBounds;
    }

    public void setUpperBounds(double[] upperBounds) {
        this.upperBounds = upperBounds;
    }

    public double[] getLowerBounds() {
        return this.lowerBounds;
    }

    public void setLowerBounds(double[] lowerBounds) {
        this.lowerBounds = lowerBounds;
    }

    public abstract NumericSolution minimize(double[] var1, CostEvaluationMethod var2, GradientEvaluationMethod var3, TerminationEvaluationMethod var4, Object var5);

    public NumericSolution minimize(double[] x_0, final CostFunction f, final int iterations) {
        return this.minimize(x_0, new CostEvaluationMethod(){

            @Override
            public double apply(double[] x, double[] lowerBounds, double[] upperBounds, Object constraint) {
                return f.evaluate(x);
            }
        }, new GradientEvaluationMethod(){

            @Override
            public void apply(double[] x, double[] Vf, double[] lowerBounds, double[] upperBounds, Object constraint) {
                f.calcGradient(x, Vf);
            }
        }, new TerminationEvaluationMethod(){

            @Override
            public boolean shouldTerminate(NumericSolutionUpdateResult state, int iteration) {
                return iteration >= iterations;
            }
        }, null);
    }

    public NumericSolution minimize(double[] x_0, final CostEvaluationMethod evaluate, final int maxIterations) {
        GradientEvaluationMethod calc_grad = new GradientEvaluationMethod(){

            @Override
            public void apply(double[] x, double[] Vf, double[] lowerBounds, double[] upperBounds, Object constraint) {
                GradientEstimation.calcGradient(x, Vf, evaluate, lowerBounds, upperBounds, constraint);
            }
        };
        TerminationEvaluationMethod should_terminate = new TerminationEvaluationMethod(){

            @Override
            public boolean shouldTerminate(NumericSolutionUpdateResult state, int iteration) {
                return iteration >= maxIterations;
            }
        };
        return this.minimize(x_0, evaluate, calc_grad, should_terminate, null);
    }

    public NumericSolution minimize(CostEvaluationMethod evaluate, int maxIterations) {
        double[] x_0 = this.createSolution();
        return this.minimize(x_0, evaluate, maxIterations);
    }

    private double[] createSolution() {
        int dimension = this.lowerBounds.length;
        double[] x_0 = new double[dimension];
        for (int i = 0; i < dimension; ++i) {
            x_0[i] = this.lowerBounds[i] * rand.nextDouble() * (this.upperBounds[i] - this.lowerBounds[i]);
        }
        return x_0;
    }

    protected void notifySolutionUpdated(NumericSolution solution, NumericSolutionUpdateResult state, int iteration) {
        this.listenerService.notifySolutionUpdated(solution, state, iteration);
    }

    protected void step(NumericSolution solution, NumericSolutionUpdateResult state, int iteration) {
        this.listenerService.step(solution, state, iteration);
    }
}

