/*
 * Decompiled with CFR 0.152.
 */
package com.github.chen0040.glm.search;

import com.github.chen0040.glm.search.CostEvaluationMethod;
import com.github.chen0040.glm.search.CostFunction;
import com.github.chen0040.glm.search.GradientEvaluationMethod;
import com.github.chen0040.glm.search.LineSearchResult;

public class LineSearch {
    private static final double SIGMA = 1.0E-4;
    private static final double BETA = 0.5;
    private static final double ZERO = 1.0E-10;

    public static LineSearchResult search(double[] x_0, double fx_0, double[] direction, CostEvaluationMethod evaluate, GradientEvaluationMethod calc_gradient, double[] lower_bounds, double[] upper_bounds, Object constraints) {
        int d;
        int dimension = x_0.length;
        double[] Vfx = new double[dimension];
        double[] x_out = new double[dimension];
        double alpha = 1.0;
        double fx_out = Double.MAX_VALUE;
        calc_gradient.apply(x_0, Vfx, lower_bounds, upper_bounds, constraints);
        double direction_length = 0.0;
        for (d = 0; d < dimension; ++d) {
            direction_length += direction[d] * direction[d];
        }
        if ((direction_length = Math.sqrt(direction_length)) > 0.0) {
            d = 0;
            while (d < dimension) {
                int n = d++;
                direction[n] = direction[n] / direction_length;
            }
        }
        double p = 0.0;
        for (int d2 = 0; d2 < dimension; ++d2) {
            p += direction[d2] * Vfx[d2];
        }
        if (Double.isNaN(p)) {
            return new LineSearchResult(x_out, fx_out, alpha, false);
        }
        if (p >= 0.0) {
            return new LineSearchResult(x_out, fx_out, alpha, false);
        }
        int k = 0;
        while (true) {
            double enumerator;
            for (int d3 = 0; d3 < dimension; ++d3) {
                x_out[d3] = x_0[d3] + alpha * direction[d3];
            }
            fx_out = evaluate.apply(x_out, lower_bounds, upper_bounds, constraints);
            if (fx_out < fx_0 + 1.0E-4 * alpha * p) {
                return new LineSearchResult(x_out, fx_out, alpha, true);
            }
            alpha = k == 0 ? ((enumerator = p + fx_0 - fx_out) == 0.0 ? 0.5 * p / enumerator : 0.5 * p) : (alpha *= 0.5);
            if (alpha < 1.0E-10) {
                if (fx_out > fx_0) {
                    for (int d4 = 0; d4 < dimension; ++d4) {
                        x_out[d4] = x_0[d4];
                    }
                    fx_out = fx_0;
                    return new LineSearchResult(x_out, fx_out, alpha, true);
                }
                return new LineSearchResult(x_out, fx_out, alpha, true);
            }
            ++k;
        }
    }

    public static LineSearchResult search(double[] x_0, double fx_0, double[] direction, CostFunction f) {
        int d;
        int dimension = x_0.length;
        double[] Vfx = new double[dimension];
        double[] x_out = new double[dimension];
        double alpha = 1.0;
        double fx_out = Double.MAX_VALUE;
        f.calcGradient(x_0, Vfx);
        double direction_length = 0.0;
        for (d = 0; d < dimension; ++d) {
            direction_length += direction[d] * direction[d];
        }
        if ((direction_length = Math.sqrt(direction_length)) > 0.0) {
            d = 0;
            while (d < dimension) {
                int n = d++;
                direction[n] = direction[n] / direction_length;
            }
        }
        double p = 0.0;
        for (int d2 = 0; d2 < dimension; ++d2) {
            p += direction[d2] * Vfx[d2];
        }
        if (Double.isNaN(p)) {
            return new LineSearchResult(x_out, fx_out, alpha, false);
        }
        if (p >= 0.0) {
            return new LineSearchResult(x_out, fx_out, alpha, false);
        }
        int k = 0;
        while (true) {
            double enumerator;
            for (int d3 = 0; d3 < dimension; ++d3) {
                x_out[d3] = x_0[d3] + alpha * direction[d3];
            }
            fx_out = f.evaluate(x_out);
            if (fx_out < fx_0 + 1.0E-4 * alpha * p) {
                return new LineSearchResult(x_out, fx_out, alpha, true);
            }
            alpha = k == 0 ? ((enumerator = p + fx_0 - fx_out) == 0.0 ? 0.5 * p / enumerator : 0.5 * p) : (alpha *= 0.5);
            if (alpha < 1.0E-10) {
                if (fx_out > fx_0) {
                    for (int d4 = 0; d4 < dimension; ++d4) {
                        x_out[d4] = x_0[d4];
                    }
                    fx_out = fx_0;
                    return new LineSearchResult(x_out, fx_out, alpha, true);
                }
                return new LineSearchResult(x_out, fx_out, alpha, true);
            }
            ++k;
        }
    }
}

