/*
 * Decompiled with CFR 0.152.
 */
package com.github.chen0040.glm.search;

import com.github.chen0040.glm.search.CostEvaluationMethod;
import com.github.chen0040.glm.search.GradientEstimation;
import com.github.chen0040.glm.search.solutions.NumericSolutionFactory;

public abstract class CostFunction
implements Cloneable {
    protected int dimensionCount;
    protected double[] lowerBounds;
    protected double[] upperBounds;
    protected Object constraint;
    protected int mEvaluationCount;

    public void copy(CostFunction rhs) {
        this.dimensionCount = rhs.dimensionCount;
        this.lowerBounds = rhs.lowerBounds == null ? null : (double[])rhs.lowerBounds.clone();
        this.upperBounds = rhs.upperBounds == null ? null : (double[])rhs.upperBounds.clone();
        this.constraint = rhs.constraint;
        this.mEvaluationCount = rhs.mEvaluationCount;
    }

    public CostFunction(int dimension_count, double lower_bound, double upper_bound) {
        this.lowerBounds = new double[dimension_count];
        this.upperBounds = new double[dimension_count];
        for (int i = 0; i < dimension_count; ++i) {
            this.lowerBounds[i] = lower_bound;
            this.upperBounds[i] = upper_bound;
        }
        this.initialize(dimension_count);
    }

    public CostFunction() {
    }

    public Object getConstraint() {
        return this.constraint;
    }

    public void setConstraint(Object constraint) {
        this.constraint = constraint;
    }

    public int getDimensionCount() {
        return this.dimensionCount;
    }

    public double getLowerBoundAtIndex(int dimension) {
        return this.lowerBounds[dimension];
    }

    public void setLowerBoundAtIndex(int dimension, double lower_bound) {
        this.lowerBounds[dimension] = lower_bound;
    }

    public double getUpperBoundAtIndex(int dimension) {
        return this.upperBounds[dimension];
    }

    public void setUpperBoundAtIndex(int dimension, double upper_bound) {
        this.upperBounds[dimension] = upper_bound;
    }

    public int getEvaluationcount() {
        return this.mEvaluationCount;
    }

    protected double _evaluate(double[] solution) {
        ++this.mEvaluationCount;
        return 0.0;
    }

    public double evaluate(double[] solution) {
        double objective_value = this._evaluate(solution);
        boolean within_bounds = true;
        for (int i = 0; i < this.dimensionCount; ++i) {
            if (!(solution[i] < this.lowerBounds[i]) && !(solution[i] > this.upperBounds[i])) continue;
            within_bounds = false;
            break;
        }
        if (!within_bounds) {
            objective_value = Double.MAX_VALUE;
        }
        return objective_value;
    }

    public double evaluate(double x) {
        double[] solution = new double[]{x};
        return this.evaluate(solution);
    }

    protected void _calcGradient(double[] solution, double[] grad) {
        GradientEstimation.calcGradient(solution, grad, new CostEvaluationMethod(){

            @Override
            public double apply(double[] x, double[] lowerBounds, double[] upperBounds, Object constraint) {
                return CostFunction.this.evaluate(x);
            }
        }, this.lowerBounds, this.upperBounds, this.constraint);
        this.mEvaluationCount += this.dimensionCount;
    }

    public void calcGradient(double[] solution, double[] grad) {
        this._calcGradient(solution, grad);
    }

    public double calcGradient(double x) {
        double[] solution = new double[]{x};
        double[] grad = new double[1];
        this._calcGradient(solution, grad);
        return grad[0];
    }

    public boolean isOutOfBounds(double[] solution) {
        boolean result = false;
        for (int i = 0; i < this.dimensionCount; ++i) {
            if (solution[i] < this.lowerBounds[i]) {
                result = true;
                break;
            }
            if (!(solution[i] > this.upperBounds[i])) continue;
            result = true;
            break;
        }
        return result;
    }

    protected void initialize(int dimension_count) {
        this.dimensionCount = dimension_count;
        this.mEvaluationCount = 0;
    }

    public double[] createRandomSolution() {
        return NumericSolutionFactory.create(this.lowerBounds, this.upperBounds);
    }
}

