/*
 * Decompiled with CFR 0.152.
 */
package com.github.chen0040.glm.metrics;

import Jama.Matrix;
import com.github.chen0040.glm.maths.Mean;
import com.github.chen0040.glm.maths.StdDev;

public class GlmStatistics
implements Cloneable {
    protected double[][] VcovMatrix;
    protected double[] residuals;
    protected double residualStdDev;
    protected double[] standardErrors;
    protected double adjustedR2;
    protected double R2;
    protected double responseVariance;
    protected double responseMean;

    public Object clone() {
        GlmStatistics clone = new GlmStatistics();
        clone.copy(this);
        return clone;
    }

    public void copy(GlmStatistics rhs) {
        this.VcovMatrix = rhs.VcovMatrix == null ? (double[][])null : (double[][])rhs.VcovMatrix.clone();
        this.residuals = rhs.residuals == null ? null : (double[])rhs.residuals.clone();
        this.residualStdDev = rhs.residualStdDev;
        this.standardErrors = rhs.standardErrors == null ? null : (double[])rhs.standardErrors.clone();
        this.adjustedR2 = rhs.adjustedR2;
        this.R2 = rhs.R2;
        this.responseVariance = rhs.responseVariance;
        this.responseMean = rhs.responseMean;
    }

    public GlmStatistics() {
    }

    public GlmStatistics(double[][] A, double[] b, double[] x) {
        int i;
        int m = A.length;
        int n = A[0].length;
        this.residuals = new double[m];
        for (int i2 = 0; i2 < m; ++i2) {
            double cross_prod = 0.0;
            for (int j = 0; j < n; ++j) {
                cross_prod += A[i2][j] * x[j];
            }
            this.residuals[i2] = b[i2] - cross_prod;
        }
        double residual_mu = 0.0;
        this.residualStdDev = StdDev.apply(this.residuals, residual_mu);
        this.responseMean = Mean.apply(b);
        this.responseVariance = Math.pow(StdDev.apply(b, this.responseMean), 2.0);
        Matrix AtA = new Matrix(n, n);
        for (int i3 = 0; i3 < n; ++i3) {
            for (int j = 0; j < n; ++j) {
                double cross_prod = 0.0;
                for (int k = 0; k < m; ++k) {
                    cross_prod += A[i3][k] * A[k][j];
                }
                AtA.set(i3, j, cross_prod);
            }
        }
        Matrix AtAInv = AtA.inverse();
        double sigmaSq = this.residualStdDev * this.residualStdDev;
        this.VcovMatrix = new double[n][];
        for (i = 0; i < n; ++i) {
            this.VcovMatrix[i] = new double[n];
            for (int j = 0; j < n; ++j) {
                this.VcovMatrix[i][j] = AtAInv.get(i, j) * sigmaSq;
            }
        }
        this.standardErrors = new double[n];
        for (i = 0; i < n; ++i) {
            this.standardErrors[i] = Math.sqrt(this.VcovMatrix[i][i]);
        }
        this.R2 = 1.0 - sigmaSq / this.responseVariance;
        this.adjustedR2 = 1.0 - sigmaSq / this.responseVariance * (double)(n - 1) / (double)(n - x.length - 1);
    }

    public GlmStatistics(int n, int m) {
        this.VcovMatrix = new double[n][];
        for (int i = 0; i < n; ++i) {
            this.VcovMatrix[i] = new double[n];
        }
        this.residuals = new double[m];
        this.standardErrors = new double[n];
    }

    public double getR2() {
        return this.R2;
    }

    public void setR2(double value) {
        this.R2 = value;
    }

    public double[][] getVCovMatrix() {
        return this.VcovMatrix;
    }

    public double[] getResiduals() {
        return this.residuals;
    }

    public double getResidualStdDev() {
        return this.residualStdDev;
    }

    public void setResidualStdDev(double value) {
        this.residualStdDev = value;
    }

    public double getRSS() {
        return this.residualStdDev * this.residualStdDev;
    }

    public double[] getStandardErrors() {
        return this.standardErrors;
    }

    public double getAdjustedR2() {
        return this.adjustedR2;
    }

    public void setAdjustedR2(double value) {
        this.adjustedR2 = value;
    }

    public double R2() {
        return this.R2;
    }

    public double getResponseVariance() {
        return this.responseVariance;
    }

    public void setResponseVariance(double value) {
        this.responseVariance = value;
    }

    public double getResponseMean() {
        return this.responseMean;
    }

    public void setResponseMean(double value) {
        this.responseMean = value;
    }
}

