/*
 * Decompiled with CFR 0.152.
 */
package com.github.chen0040.glm.metrics;

import com.github.chen0040.data.frame.DataFrame;
import com.github.chen0040.data.frame.DataRow;
import com.github.chen0040.glm.enums.GlmDistributionFamily;
import com.github.chen0040.glm.maths.Mean;
import com.github.chen0040.glm.maths.StdDev;

public class GlmLikelihoodFunction {
    public static double getLikelihood(GlmDistributionFamily distribution, DataFrame data, double[] beta_hat) {
        switch (distribution) {
            case Normal: {
                return GlmLikelihoodFunction.GetLikelihood_Normal(data, beta_hat);
            }
        }
        return Double.NaN;
    }

    private static double GetLikelihood_Normal(DataFrame data, double[] beta_hat) {
        int N = data.rowCount();
        int k = beta_hat.length;
        double residual_sum_of_squares = 0.0;
        double[] y = new double[N];
        for (int i = 0; i < N; ++i) {
            y[i] = data.row(i).target();
        }
        double sigma = StdDev.apply(y, Mean.apply(y)) / (double)(N - k - 1);
        for (int i = 0; i < N; ++i) {
            double linear_predictor = 0.0;
            DataRow rec = data.row(i);
            double[] values = rec.toArray();
            for (int j = 0; j < k; ++j) {
                linear_predictor += values[j] * beta_hat[j];
            }
            double residual = rec.target() - linear_predictor;
            residual_sum_of_squares += residual * residual;
        }
        return Math.exp(-residual_sum_of_squares / (2.0 * sigma)) / Math.sqrt(Math.PI * 2 * sigma);
    }
}

