/*
 * Decompiled with CFR 0.152.
 */
package com.github.chen0040.benchmarks;

public class Vector2D {
    public final double x;
    public final double y;

    public Vector2D(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public double distanceSq(Vector2D that) {
        double dx = this.x - that.x;
        double dy = this.y - that.y;
        return dx * dx + dy * dy;
    }

    public double distance(Vector2D that) {
        return Math.sqrt(this.distanceSq(that));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Vector2D vector2D = (Vector2D)o;
        if (Double.compare(vector2D.x, this.x) != 0) {
            return false;
        }
        return Double.compare(vector2D.y, this.y) == 0;
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.x);
        int result = (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.y);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public String toString() {
        return "(x=" + this.x + ", y=" + this.y + ')';
    }
}

